/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.webapp;

import java.io.InputStream;
import javax.faces.internal.FacesConfigOptions;
import javax.servlet.ServletContext;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.config.faces.FacesConfigBuilder;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.webapp.WebappConfigBuilder;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.util.DIContainerUtil;

public class TeedaInitializer {
    private ServletContext servletContext;

    public void initializeFaces() {
        ServletContext context = this.getServletContext();
        if (context == null) {
            throw new IllegalStateException("servletContext must not be null.");
        }
        this.initializeFacesConfigOptions(context);
        this.initializeFacesConfigCustomOptions(context);
        this.buildFacesConfig();
        this.buildWebAppConfig(context);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected void initializeFacesConfigOptions(ServletContext servletContext) {
        String defaultGridAsync;
        String suffix;
        FacesConfigOptions.setConfigFiles(servletContext.getInitParameter("javax.faces.CONFIG_FILES"));
        String savingMethod = servletContext.getInitParameter("javax.faces.STATE_SAVING_METHOD");
        if (savingMethod != null) {
            FacesConfigOptions.setSavingStateInClient("client".equalsIgnoreCase(savingMethod));
        }
        if ((suffix = servletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX")) != null) {
            FacesConfigOptions.setDefaultSuffix(suffix);
        } else {
            FacesConfigOptions.setDefaultSuffix(".jsp");
        }
        String lifecycleId = servletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId != null) {
            FacesConfigOptions.setLifecycleId(lifecycleId);
        }
        if ((defaultGridAsync = servletContext.getInitParameter("teeda.DEFAULT_GRID_ASYNC")) != null) {
            FacesConfigOptions.setDefaultGridAsync(Boolean.valueOf(defaultGridAsync));
        }
    }

    protected void initializeFacesConfigCustomOptions(ServletContext servletContext) {
        String compressState;
        String javaScriptNotPermittedPath = servletContext.getInitParameter("teeda.JAVASCRIPT_NOT_PERMITTED_PATH");
        if (javaScriptNotPermittedPath != null) {
            String[] paths = StringUtil.split((String)javaScriptNotPermittedPath, (String)",");
            FacesConfigOptions.setJavascriptNotPermittedPath(paths);
        }
        if ((compressState = servletContext.getInitParameter("javax.faces.COMPRESS_STATE")) != null) {
            FacesConfigOptions.setCompressState(compressState.equalsIgnoreCase("true"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildWebAppConfig(ServletContext servletContext) {
        WebappConfigBuilder webAppConfigBuilder = (WebappConfigBuilder)DIContainerUtil.getComponent(WebappConfigBuilder.class);
        InputStream is = null;
        WebappConfig webappConfig = null;
        try {
            is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
            webappConfig = webAppConfigBuilder.build(is, "/WEB-INF/web.xml");
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
        servletContext.setAttribute(WebappConfig.class.getName(), (Object)webappConfig);
    }

    protected void buildFacesConfig() {
        FacesConfigBuilder facesConfigBuilder = (FacesConfigBuilder)DIContainerUtil.getComponent(FacesConfigBuilder.class);
        FacesConfig facesConfig = facesConfigBuilder.buildFacesConfigs();
        AssemblerAssembler assembler = (AssemblerAssembler)DIContainerUtil.getComponent(AssemblerAssembler.class);
        assembler.assembleFactories(facesConfig);
        assembler.assembleApplication(facesConfig);
        assembler.assembleManagedBeans(facesConfig);
        assembler.assmbleNavigationRules(facesConfig);
        assembler.assembleLifecycle(facesConfig);
        assembler.assembleRenderKits(facesConfig);
    }
}

