/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.webapp;

import java.io.InputStream;
import javax.faces.FactoryFinder;
import javax.faces.internal.FacesConfigOptions;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.seasar.framework.container.servlet.PortletExtendedS2ContainerListener;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.ProductInfo;
import org.seasar.teeda.core.config.faces.FacesConfigBuilder;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.webapp.WebappConfigBuilder;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.util.DIContainerUtil;

public class TeedaPortletExtendedConfigureListener
extends PortletExtendedS2ContainerListener {
    private static final String FACES_INIT_DONE = TeedaPortletExtendedConfigureListener.class.getName() + ".FACES_INIT_DONE";
    private static Logger logger = Logger.getLogger((Class)TeedaPortletExtendedConfigureListener.class);

    public void contextInitialized(ServletContextEvent event) {
        super.contextInitialized(event);
        this.printVersion();
        logger.debug((Object)"JSF initialize start");
        try {
            this.initializeFaces(event.getServletContext());
        }
        catch (RuntimeException e) {
            logger.log((Throwable)e);
            throw e;
        }
        logger.debug((Object)"JSF initialize end");
    }

    public void contextDestroyed(ServletContextEvent event) {
        super.contextDestroyed(event);
        FactoryFinder.releaseFactories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeFaces(ServletContext servletContext) {
        boolean isAlreadyInitialized;
        Boolean b = (Boolean)servletContext.getAttribute(FACES_INIT_DONE);
        boolean bl = isAlreadyInitialized = b != null ? b : false;
        if (!isAlreadyInitialized) {
            this.initializeFacesConfigOptions(servletContext);
            this.initializeFacesConfigCustomOptions(servletContext);
            FacesConfigBuilder facesConfigBuilder = (FacesConfigBuilder)DIContainerUtil.getComponent(FacesConfigBuilder.class);
            FacesConfig facesConfig = facesConfigBuilder.buildFacesConfigs();
            AssemblerAssembler assembler = (AssemblerAssembler)DIContainerUtil.getComponent(AssemblerAssembler.class);
            assembler.assembleFactories(facesConfig);
            assembler.assembleApplication(facesConfig);
            assembler.assembleManagedBeans(facesConfig);
            assembler.assmbleNavigationRules(facesConfig);
            assembler.assembleLifecycle(facesConfig);
            assembler.assembleRenderKits(facesConfig);
            WebappConfigBuilder webAppConfigBuilder = (WebappConfigBuilder)DIContainerUtil.getComponent(WebappConfigBuilder.class);
            InputStream is = null;
            WebappConfig webappConfig = null;
            try {
                is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                webappConfig = webAppConfigBuilder.build(is, "/WEB-INF/web.xml");
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
            servletContext.setAttribute(WebappConfig.class.getName(), (Object)webappConfig);
            servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
        }
    }

    protected void initializeFacesConfigOptions(ServletContext servletContext) {
        String suffix;
        FacesConfigOptions.setConfigFiles(servletContext.getInitParameter("javax.faces.CONFIG_FILES"));
        String savingMethod = servletContext.getInitParameter("javax.faces.STATE_SAVING_METHOD");
        if (savingMethod != null) {
            FacesConfigOptions.setSavingStateInClient("client".equalsIgnoreCase(savingMethod));
        }
        if ((suffix = servletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX")) != null) {
            FacesConfigOptions.setDefaultSuffix(suffix);
        } else {
            FacesConfigOptions.setDefaultSuffix(".jsp");
        }
        String lifecycleId = servletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId != null) {
            FacesConfigOptions.setLifecycleId(lifecycleId);
        }
    }

    protected void initializeFacesConfigCustomOptions(ServletContext servletContext) {
        String compressState;
        String javaScriptNotPermittedPath = servletContext.getInitParameter("teeda.JAVASCRIPT_NOT_PERMITTED_PATH");
        if (javaScriptNotPermittedPath != null) {
            String[] paths = StringUtil.split((String)javaScriptNotPermittedPath, (String)",");
            FacesConfigOptions.setJavascriptNotPermittedPath(paths);
        }
        if ((compressState = servletContext.getInitParameter("javax.faces.COMPRESS_STATE")) != null) {
            FacesConfigOptions.setCompressState(compressState.equalsIgnoreCase("true"));
        }
    }

    private void printVersion() {
        logger.debug((Object)("Teeda version :" + ProductInfo.getVersion()));
    }
}

