/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.entity;

import java.io.File;
import java.util.Date;

/**
 * @author shinsuke
 * 
 */
public class WikiPage {
    private String pageName;

    private File file;

    private Date updated;

    /**
     * @return Returns the file.
     */
    public File getFile() {
        return file;
    }

    /**
     * @param file
     *            The file to set.
     */
    public void setFile(File file) {
        this.file = file;
    }

    /**
     * @return Returns the title.
     */
    public String getPageName() {
        return pageName;
    }

    /**
     * @param title
     *            The title to set.
     */
    public void setPageName(String title) {
        this.pageName = title;
    }

    /**
     * @return Returns the updated.
     */
    public Date getUpdated() {
        return updated;
    }

    /**
     * @param updated
     *            The updated to set.
     */
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    /**
     * @return Returns the label.
     */
    public String getLabel() {
        return pageName;
    }

    /**
     * @return Returns the value.
     */
    public String getValue() {
        return pageName;
    }

}
