/*
 * Copyright 2004-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.wiki.portlet;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import jp.sf.pal.wiki.WikiConstants;
import jp.sf.stconv.wiki.pipeline.callback.LinkGeneratorCallback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

/**
 * @author shinsuke
 * 
 */
public class WikiPortletFilter implements PortletFilter {
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(WikiPortletFilter.class);

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#destroy()
     */
    public void destroy() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#init(org.apache.portals.bridges.portletfilter.PortletFilterConfig)
     */
    public void init(PortletFilterConfig filterConfig) throws PortletException {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#processActionFilter(javax.portlet.ActionRequest,
     *      javax.portlet.ActionResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void processActionFilter(ActionRequest request,
            ActionResponse response, PortletFilterChain chain)
            throws PortletException, IOException {
        chain.processActionFilter(request, response);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.apache.portals.bridges.portletfilter.PortletFilter#renderFilter(javax.portlet.RenderRequest,
     *      javax.portlet.RenderResponse,
     *      org.apache.portals.bridges.portletfilter.PortletFilterChain)
     */
    public void renderFilter(RenderRequest request, RenderResponse response,
            PortletFilterChain chain) throws PortletException, IOException {
        String pageName = request.getParameter(LinkGeneratorCallback.PAGE_NAME);
        if (pageName != null) {
            request.getPortletSession().setAttribute(
                    WikiConstants.CURRENT_PAGE_NAME, pageName);
        }

        chain.renderFilter(request, response);

    }
}
