/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.stconv.wiki.pukiwiki.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;
import jp.sf.stconv.wiki.pukiwiki.pipeline.valve.AbstractWikiValve;

public class ConvertBlockQuotationValve
extends AbstractWikiValve {
    private String pattern = "^>{1,3}?.*";
    private boolean tagStarted;
    private int blockCount;

    protected String getPattern() {
        return this.pattern;
    }

    protected void writeMatchLine(BufferedWriter writer, String line) throws IOException {
        this.log.debug((Object)"HIT");
        String newLine = line.replaceFirst(">{1,3}\\s*", "");
        if (this.tagStarted) {
            writer.write("</p><blockquote><p class=\"quotation\">" + newLine);
        } else {
            writer.write("<blockquote><p class=\"quotation\">" + newLine);
        }
        this.tagStarted = true;
        ++this.blockCount;
        writer.newLine();
    }

    protected void writeUnmatchLine(BufferedWriter writer, String line) throws IOException {
        this.log.debug((Object)"NOT HIT");
        if (this.tagStarted && line.length() == 0) {
            writer.write("</p>");
            for (int i = this.blockCount; i > 0; --i) {
                writer.write("</blockquote>");
            }
            this.blockCount = 0;
            this.tagStarted = false;
        }
        writer.write(line);
        writer.newLine();
    }

    protected void finish(BufferedWriter writer) throws IOException {
        if (this.tagStarted) {
            writer.write("</p>");
            for (int i = this.blockCount; i > 0; --i) {
                writer.write("</blockquote>");
            }
            this.blockCount = 0;
            writer.newLine();
            this.tagStarted = false;
        } else {
            super.finish(writer);
        }
    }
}

