/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.env;

import java.io.File;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TextUtil;

public class Env {
    public static final String PRODUCT = "product";
    public static final String UT = "ut";
    public static final String CT = "ct";
    public static final String IT = "it";
    public static final String DEFAULT_FILE_PATH = "env.txt";
    private static String value;
    private static String filePath;
    private static File file;
    private static long lastModified;

    private Env() {
    }

    public static void initialize() {
        Env.setFilePath(DEFAULT_FILE_PATH);
    }

    public static String getValue() {
        if (file != null && file.lastModified() > lastModified) {
            Env.calcValue();
        }
        if (StringUtil.isEmpty(value)) {
            return PRODUCT;
        }
        return value;
    }

    public static boolean setValueIfAbsent(String newValue) {
        if (value == null) {
            value = newValue;
            return true;
        }
        return false;
    }

    public static String adjustPath(String path) {
        String env = Env.getValue();
        if (PRODUCT.equals(env)) {
            return path;
        }
        int index = path.lastIndexOf(46);
        if (index < 0) {
            return path;
        }
        String p = path.substring(0, index);
        String ext = path.substring(index + 1);
        return p + "_" + env + "." + ext;
    }

    public static String getFilePath() {
        return filePath;
    }

    public static void setFilePath(String filePath) {
        if (filePath == null) {
            throw new EmptyRuntimeException("filePath");
        }
        Env.filePath = filePath;
        file = ResourceUtil.getResourceAsFileNoException(filePath);
        if (file != null) {
            Env.calcValue();
        } else {
            Env.clearValue();
        }
    }

    protected static void calcValue() {
        value = TextUtil.readUTF8(file);
        if (value != null) {
            value = value.trim();
        }
        lastModified = file.lastModified();
    }

    protected static void clearValue() {
        value = null;
        lastModified = 0L;
    }

    static {
        filePath = DEFAULT_FILE_PATH;
        Env.initialize();
    }
}

