/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.internal.ValidatorResource;
import javax.faces.validator.Validator;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.extension.annotation.handler.ValidatorAnnotationHandler;

public abstract class AbstractValidatorAnnotationHandler
implements ValidatorAnnotationHandler {
    private Map expressionsMap = new HashMap();

    public void registerValidator(String componentName, String propertyName, Validator validator) {
        String expression = BindingUtil.getExpression((String)componentName, (String)propertyName);
        ValidatorResource.addValidator((String)expression, (Validator)validator);
        HashSet<String> expressions = (HashSet<String>)this.expressionsMap.get(componentName);
        if (expressions == null) {
            expressions = new HashSet<String>();
            this.expressionsMap.put(componentName, expressions);
        }
        expressions.add(expression);
    }

    public void removeValidators(String componentName) {
        Set expressions = (Set)this.expressionsMap.get(componentName);
        if (expressions == null) {
            return;
        }
        Iterator i = expressions.iterator();
        while (i.hasNext()) {
            String expression = (String)i.next();
            ValidatorResource.removeValidator((String)expression);
        }
        this.expressionsMap.remove(componentName);
    }

    public void removeAll() {
        Iterator i = this.expressionsMap.keySet().iterator();
        while (i.hasNext()) {
            String componentName = (String)i.next();
            this.removeValidators(componentName);
        }
    }

    public int getExpressionSize(String componentName) {
        Set expressions = (Set)this.expressionsMap.get(componentName);
        if (expressions == null) {
            return 0;
        }
        return expressions.size();
    }

    protected S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}

