/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.lang.reflect.Field;
import java.util.Map;
import javax.faces.convert.Converter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.ConstantAnnotationUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.FieldUtil;
import org.seasar.teeda.extension.annotation.handler.AbstractConverterAnnotationHandler;

public class ConstantConverterAnnotationHandler
extends AbstractConverterAnnotationHandler {
    public void registerConverters(String componentName) {
        S2Container container = this.getContainer();
        NamingConvention namingConvention = (NamingConvention)container.getComponent((Object)NamingConvention.class);
        ComponentDef componentDef = container.getComponentDef((Object)componentName);
        Class componentClass = componentDef.getComponentClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)componentClass);
        this.processFields(container, componentClass, componentName, namingConvention, beanDesc);
        this.processGetterMethods(container, componentClass, componentName, namingConvention, beanDesc);
    }

    protected void processFields(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc) {
        Field[] fields = componentClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            this.processField(container, componentClass, componentName, namingConvention, beanDesc, fields[i]);
        }
    }

    protected void processField(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc, Field field) {
        boolean isConstantAnnotation = ConstantAnnotationUtil.isConstantAnnotation((Field)field);
        if (!isConstantAnnotation || !field.getName().endsWith(namingConvention.getConverterSuffix())) {
            return;
        }
        String fieldString = field.getName();
        int index = fieldString.lastIndexOf("_");
        String fieldName = fieldString.substring(0, index);
        String converterName = fieldString.substring(index + 1);
        if (!beanDesc.hasPropertyDesc(fieldName) || !container.hasComponentDef((Object)converterName)) {
            return;
        }
        Converter converter = this.getConverter(container, converterName);
        if (converter == null) {
            return;
        }
        String s = (String)FieldUtil.get((Field)field, null);
        Map m = ConstantAnnotationUtil.convertExpressionToMap((String)s);
        BeanUtil.copyProperties((Map)m, (Object)converter);
        this.registerConverter(componentName, fieldName, converter);
    }

    protected Converter getConverter(S2Container container, String converterName) {
        ComponentDef cd;
        if (!Converter.class.isAssignableFrom((cd = container.getComponentDef((Object)converterName)).getComponentClass())) {
            return null;
        }
        return (Converter)cd.getComponent();
    }

    protected void processGetterMethods(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc) {
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (!pd.hasReadMethod()) continue;
            this.processGetterMethod(container, componentClass, componentName, namingConvention, beanDesc, pd);
        }
    }

    protected void processGetterMethod(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, BeanDesc beanDesc, PropertyDesc propertyDesc) {
    }
}

