/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.VariableResolver;
import javax.faces.internal.ComponentStates;
import javax.faces.internal.ComponentStatesHolder;
import javax.faces.internal.FacesMessageResource;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.NamingContainerUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.teeda.core.util.BindingUtil;

public class TForEach
extends UIComponentBase
implements NamingContainer,
ComponentStatesHolder {
    public static final String COMPONENT_TYPE = "org.seasar.teeda.extension.ForEach";
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.ForEach";
    private static final String DEFAULT_RENDERER_TYPE = "org.seasar.teeda.extension.ForEach";
    private static final Object[] EMPTY_ITEMS = new Object[0];
    private static final String INDEX_SUFFIX = "Index";
    private static final int INITIAL_ROW_INDEX = -1;
    private int rowIndex = -1;
    private int rowSize;
    private final ComponentStates componentStates = new ComponentStates();
    private String pageName;
    private String itemsName;
    private static final Logger logger = Logger.getLogger((Class)TForEach.class);

    public TForEach() {
        this.setRendererType("org.seasar.teeda.extension.ForEach");
    }

    public void setId(String id) {
        super.setId(id);
        NamingContainerUtil.refreshDescendantComponentClientId((UIComponent)this);
    }

    public String getClientId(FacesContext context) {
        String clientId = super.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        return clientId + ':' + rowIndex;
    }

    private int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public String getItemsName() {
        return this.itemsName;
    }

    public void setItemsName(String itemsName) {
        if (itemsName != null && !itemsName.endsWith("Items")) {
            throw new IllegalArgumentException(itemsName);
        }
        this.itemsName = itemsName;
    }

    public String getItemName() {
        if (this.itemsName == null) {
            return null;
        }
        return this.itemsName.substring(0, this.itemsName.length() - "Items".length());
    }

    public String getIndexName() {
        String itemName = this.getItemName();
        if (itemName == null) {
            return null;
        }
        return itemName + INDEX_SUFFIX;
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getFamily() {
        return "org.seasar.teeda.extension.ForEach";
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Object page = this.getPage(context);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        if (beanDesc.hasPropertyDesc(this.getItemName())) {
            PropertyDesc itemPd = beanDesc.getPropertyDesc(this.getItemName());
            Class itemType = itemPd.getPropertyType();
            Object item = this.createNewInstance(context, itemType);
            itemPd.setValue(page, item);
        }
        String pageName = this.getPageName();
        String id = this.getId();
        String expression = BindingUtil.getExpression((String)pageName, (String)id);
        for (int i = 0; i < this.rowSize; ++i) {
            this.enterRow(context, i);
            super.processValidators(context);
            String parentClientId = this.getClientId(context);
            if (!FacesMessageResource.hasMessages((String)expression)) {
                this.processEachRowValidation(context, i, parentClientId);
            }
            this.leaveRow(context);
        }
        this.aggregateErrorMessageIfNeed(context, expression);
    }

    protected void processEachRowValidation(FacesContext context, int row, String parentClientId) {
        if (FacesMessageUtil.hasMessages((FacesContext)context)) {
            this.appendLineInfoToErrorMessage(context, parentClientId, row);
        }
    }

    protected void aggregateErrorMessageIfNeed(FacesContext context, String expression) {
        if (FacesMessageResource.hasMessages((String)expression)) {
            String parentRowClientId = super.getClientId(context);
            FacesMessage aggregateMessage = FacesMessageResource.getFacesMessage((String)expression);
            this.aggregateErrorMessage(aggregateMessage, context, parentRowClientId);
        }
    }

    protected boolean aggregateErrorMessage(FacesMessage aggregateMessage, FacesContext context, String parentClientId) {
        boolean shouldAggregate = false;
        HashMap<String, Iterator> map = new HashMap<String, Iterator>();
        String saveClientId = null;
        HashSet<String> clientIds = new HashSet<String>();
        Iterator itr = context.getClientIdsWithMessages();
        while (itr.hasNext()) {
            String clientId = (String)itr.next();
            clientIds.add(clientId);
            if (!clientId.startsWith(parentClientId)) {
                Iterator messages = context.getMessages(clientId);
                map.put(clientId, messages);
                continue;
            }
            if (shouldAggregate) continue;
            saveClientId = clientId;
            shouldAggregate = true;
        }
        if (shouldAggregate) {
            BeanDesc bd = BeanDescFactory.getBeanDesc(context.getClass());
            Field field = bd.getField("messages");
            FieldUtil.set((Field)field, (Object)context, null);
            Iterator itr2 = map.entrySet().iterator();
            while (itr2.hasNext()) {
                Map.Entry entry = itr2.next();
                Iterator messages = (Iterator)entry.getValue();
                while (messages.hasNext()) {
                    FacesMessage fm = (FacesMessage)messages.next();
                    context.addMessage(null, fm);
                }
            }
            context.addMessage(saveClientId, aggregateMessage);
            ExternalContext externalContext = context.getExternalContext();
            Map requestMap = externalContext.getRequestMap();
            requestMap.put("org.seasar.teeda.extension.message.clientids", clientIds);
        }
        return shouldAggregate;
    }

    protected void appendLineInfoToErrorMessage(FacesContext context, String parentClientId, int row) {
        Iterator itr = context.getClientIdsWithMessages();
        while (itr.hasNext()) {
            String clientId = (String)itr.next();
            if (!clientId.startsWith(parentClientId)) continue;
            Iterator messages = context.getMessages(clientId);
            while (messages.hasNext()) {
                FacesMessage fm = (FacesMessage)messages.next();
                String summary = fm.getSummary();
                String detail = fm.getDetail();
                if (summary == null && detail == null) continue;
                String lineErrorMessage = this.getLineErrorMessage(context, row + 1);
                if (summary != null) {
                    if (lineErrorMessage != null) {
                        fm.setSummary(summary + lineErrorMessage);
                    } else {
                        fm.setSummary(summary + "(line : " + (row + 1) + ")");
                    }
                }
                if (detail == null) continue;
                if (lineErrorMessage != null) {
                    fm.setDetail(detail + lineErrorMessage);
                    continue;
                }
                fm.setDetail(detail + "(line : " + (row + 1) + ")");
            }
        }
    }

    protected String getLineErrorMessage(FacesContext context, int linenumber) {
        String message = FacesMessageUtil.getSummary((FacesContext)context, (String)"org.seasar.teeda.extension.component.TForEach.line", (Object[])new Object[]{new Integer(linenumber)});
        return message;
    }

    protected Object createNewInstance(FacesContext context, Class itemType) {
        AssertionUtil.assertNotNull((String)"itemType", (Object)itemType);
        Object o = null;
        if (itemType.isPrimitive()) {
            itemType = ClassUtil.getWrapperClassIfPrimitive((Class)itemType);
        }
        if (itemType == Integer.class) {
            return new Integer("0");
        }
        if (itemType == Long.class) {
            return new Long("0");
        }
        if (itemType == Double.class) {
            return new Double("0");
        }
        if (itemType == Float.class) {
            return new Float("0");
        }
        if (itemType == Short.class) {
            return new Short("0");
        }
        if (itemType == BigDecimal.class) {
            return new BigDecimal("0");
        }
        if (itemType == BigInteger.class) {
            return new BigInteger("0");
        }
        if (itemType == Boolean.class) {
            return Boolean.FALSE;
        }
        if (itemType == Calendar.class) {
            Locale locale = context.getViewRoot().getLocale();
            return Calendar.getInstance(locale);
        }
        o = ClassUtil.newInstance((Class)itemType);
        return o;
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        Object page = this.getPage(context);
        Object pageClone = ClassUtil.newInstance(page.getClass());
        BeanUtil.copyProperties((Object)page, (Object)pageClone);
        BeanDesc pageBeanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        PropertyDesc itemsPd = pageBeanDesc.getPropertyDesc(this.getItemsName());
        if (!itemsPd.hasWriteMethod()) {
            throw new IllegalStateException("class [" + pageBeanDesc.getBeanClass().getName() + "] should have writeMethod for [" + itemsPd.getPropertyName() + "]");
        }
        Class itemsClass = itemsPd.getPropertyType();
        Class<?> itemClass = itemsClass.getComponentType();
        if (itemClass == null) {
            logger.debug((Object)("class [" + itemsClass.getName() + "] should be array type, so no update."));
            return;
        }
        Object[] items = (Object[])itemsPd.getValue(page);
        if (items == null) {
            items = (Object[])Array.newInstance(itemClass, this.rowSize);
            for (int i = 0; i < items.length; ++i) {
                items[i] = this.createNewInstance(context, itemClass);
            }
        }
        if (pageBeanDesc.hasPropertyDesc(this.getItemName())) {
            PropertyDesc itemPd = pageBeanDesc.getPropertyDesc(this.getItemName());
            for (int i = 0; i < this.rowSize; ++i) {
                this.setRowIndex(i);
                itemPd.setValue(page, items[i]);
                this.enterRow(context, i);
                super.processUpdates(context);
                this.leaveRow(context);
            }
        } else {
            int i;
            BeanDesc itemBeanDesc = BeanDescFactory.getBeanDesc(itemClass);
            for (i = 0; i < this.rowSize; ++i) {
                Object item = items[i];
                this.itemToPage(pageBeanDesc, page, item);
                this.enterRow(context, i);
                super.processUpdates(context);
                this.leaveRow(context);
                this.pageToItem(page, pageBeanDesc, item, itemBeanDesc);
            }
            for (i = 0; i < itemBeanDesc.getPropertyDescSize(); ++i) {
                PropertyDesc itemPd = itemBeanDesc.getPropertyDesc(i);
                String propertyName = itemPd.getPropertyName();
                if (!pageBeanDesc.hasPropertyDesc(propertyName)) continue;
                PropertyDesc pagePd = pageBeanDesc.getPropertyDesc(propertyName);
                pagePd.setValue(page, pagePd.getValue(pageClone));
            }
        }
        itemsPd.setValue(page, (Object)items);
    }

    private void pageToItem(Object page, BeanDesc pageBeanDesc, Object item, BeanDesc itemBeanDesc) {
        for (int i = 0; i < itemBeanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc itemPd = itemBeanDesc.getPropertyDesc(i);
            String propertyName = itemPd.getPropertyName();
            if (!pageBeanDesc.hasPropertyDesc(propertyName)) continue;
            PropertyDesc pagePd = pageBeanDesc.getPropertyDesc(propertyName);
            Object pageValue = pagePd.getValue(page);
            itemPd.setValue(item, pageValue);
        }
    }

    public void enterRow(FacesContext context, int rowIndex) {
        this.setRowIndex(rowIndex);
        this.componentStates.restoreDescendantState(context, (UIComponent)this);
    }

    public void leaveRow(FacesContext context) {
        this.componentStates.saveDescendantComponentStates(context, (UIComponent)this);
    }

    public Object getPage(FacesContext context) {
        VariableResolver variableResolver = context.getApplication().getVariableResolver();
        return variableResolver.resolveVariable(context, this.getPageName());
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.pageName, this.itemsName};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.pageName = (String)values[1];
        this.itemsName = (String)values[2];
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setRowSize(int rowCount) {
        this.rowSize = rowCount;
    }

    public Object[] getItems(FacesContext context) {
        Object page = this.getPage(context);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        PropertyDesc pd = beanDesc.getPropertyDesc(this.getItemsName());
        Object items = pd.getValue(page);
        if (items == null) {
            return EMPTY_ITEMS;
        }
        if (items instanceof Collection) {
            return ((Collection)items).toArray();
        }
        if (items.getClass().isArray()) {
            return (Object[])items;
        }
        throw new IllegalStateException(items.getClass().toString());
    }

    public void processItem(BeanDesc pageBeanDesc, Object page, Object item, int index) {
        String indexName = this.getIndexName();
        Integer indexValue = new Integer(index);
        this.setValue(pageBeanDesc, page, indexName, indexValue);
        this.itemToPage(pageBeanDesc, page, item);
    }

    private void itemToPage(BeanDesc pageBeanDesc, Object page, Object item) {
        if (item == null) {
            return;
        }
        String itemName = this.getItemName();
        this.setValue(pageBeanDesc, page, itemName, item);
        if (item instanceof Map) {
            this.processMapItem(pageBeanDesc, page, (Map)item);
        } else {
            this.processBeanItem(pageBeanDesc, page, item);
        }
    }

    protected void processBeanItem(BeanDesc beanDesc, Object page, Object item) {
        BeanDesc itemBeanDesc = BeanDescFactory.getBeanDesc(item.getClass());
        for (int i = 0; i < itemBeanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = itemBeanDesc.getPropertyDesc(i);
            String name = pd.getPropertyName();
            Object value = this.getValue(itemBeanDesc, item, name);
            this.setValue(beanDesc, page, name, value);
        }
    }

    protected void processMapItem(BeanDesc beanDesc, Object page, Map item) {
        Iterator i = item.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = item.get(name);
            this.setValue(beanDesc, page, name, value);
        }
    }

    protected Object getValue(BeanDesc beanDesc, Object page, String propertyName) {
        PropertyDesc pd;
        if (beanDesc.hasPropertyDesc(propertyName) && (pd = beanDesc.getPropertyDesc(propertyName)).hasReadMethod()) {
            return pd.getValue(page);
        }
        return null;
    }

    protected void setValue(BeanDesc beanDesc, Object page, String propertyName, Object value) {
        if (beanDesc.hasPropertyDesc(propertyName)) {
            Class<?> valueClass;
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            Class pdClass = pd.getPropertyType();
            if (pdClass.isPrimitive()) {
                pdClass = ClassUtil.getWrapperClass((Class)pdClass);
            }
            Class<?> clazz = valueClass = value != null ? value.getClass() : null;
            if (pd.hasWriteMethod() && TForEach.isRelatedClass(pdClass, valueClass)) {
                pd.setValue(page, value);
            }
        }
    }

    protected static boolean isRelatedClass(Class pdClass, Class valueClass) {
        if (valueClass == null) {
            return true;
        }
        return pdClass == valueClass || pdClass.isAssignableFrom(valueClass);
    }
}

