/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class CommandButtonFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "commandButton";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"input".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String type = elementNode.getProperty("type");
        if (!("submit".equalsIgnoreCase(type) || "button".equalsIgnoreCase(type) || "image".equalsIgnoreCase(type))) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (id.startsWith("go")) {
            return true;
        }
        if (id.startsWith("do")) {
            if (pageDesc != null && pageDesc.hasMethod(id)) {
                return true;
            }
            if (actionDesc != null && actionDesc.hasMethod(id)) {
                return true;
            }
        }
        return id.startsWith("jump");
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String next;
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        String id = elementNode.getId();
        if (id.startsWith("go")) {
            next = StringUtil.decapitalize((String)id.substring(2));
            properties.put("action", next);
        } else if (id.startsWith("jump")) {
            next = StringUtil.decapitalize((String)id.substring("jump".length()));
            properties.put("action", next);
            properties.put("immediate", "true");
        } else {
            String baseName = null;
            baseName = pageDesc != null && pageDesc.hasMethod(id) ? pageDesc.getPageName() : actionDesc.getActionName();
            properties.put("action", this.getBindingExpression(baseName, id));
        }
        String onclick = elementNode.getProperty("onclick");
        String dynamicOnclick = (String)properties.get("onclick");
        if (!StringUtil.isEmpty((String)onclick) && !BindingUtil.isValueReference((String)dynamicOnclick)) {
            onclick = this.removeTemplateOnlyString(onclick, "location.href");
            onclick = this.removeTemplateOnlyString(onclick, "history.back()");
            properties.put("onclick", onclick);
        }
        this.renameProperty(properties, "src", "image");
    }

    protected String removeTemplateOnlyString(String onclick, String target) {
        int start = onclick.indexOf(target);
        if (start >= 0) {
            int end = onclick.indexOf(";");
            if (end < 0) {
                onclick = "";
            } else {
                int end2 = onclick.indexOf(";", start);
                String prefix = onclick.substring(0, start);
                String suffix = onclick.substring(end2 + 1);
                onclick = prefix + suffix;
            }
        }
        return onclick;
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://java.sun.com/jsf/html";
    }
}

