/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.TextNode;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.html.factory.LabelFactoryUtil;

public class OutputTextFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "outputText";
    private NamingConvention nc;

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"span".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (OutputTextFactory.isLabelSpan(id, elementNode)) {
            return true;
        }
        return pageDesc.hasProperty(id);
    }

    public boolean isLeaf() {
        return true;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String id = elementNode.getId();
        boolean isLabel = OutputTextFactory.isLabelSpan(id, elementNode);
        if (isLabel) {
            TextNode firstTextNode = elementNode.getFirstTextNode();
            properties.put("value", firstTextNode.getValue());
        } else {
            properties.put("value", this.getBindingExpression(pageDesc.getPageName(), id));
        }
        ElementNode parent = elementNode.getParent();
        if (parent != null) {
            String tagName = parent.getTagName();
            if (id.endsWith("Label") && tagName.equalsIgnoreCase("a")) {
                LabelFactoryUtil.storeLabelAttributesTo(properties, elementNode, pageDesc, this.nc);
            }
        }
    }

    protected static boolean isLabelSpan(String id, ElementNode elementNode) {
        ElementNode parent = elementNode.getParent();
        if (parent == null) {
            return false;
        }
        String tagName = parent.getTagName();
        return id.endsWith("Label") && tagName.equalsIgnoreCase("a");
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.nc = namingConvention;
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }
}

