/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.internal.scope.RedirectScope;
import javax.servlet.ServletContext;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.NavigationHandlerImpl;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.ServletContextUtil;
import org.seasar.teeda.extension.html.HtmlSuffix;
import org.seasar.teeda.extension.html.PagePersistence;

public class HtmlNavigationHandler
extends NavigationHandlerImpl {
    private PagePersistence pagePersistence;
    private NamingConvention namingConvention;
    private ServletContext servletContext;
    private HtmlSuffix htmlSuffix;

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void setPagePersistence(PagePersistence pagePersistence) {
        this.pagePersistence = pagePersistence;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    protected void redirect(FacesContext context, ExternalContext externalContext, String redirectPath, String newViewId) {
        this.pagePersistence.save(context, newViewId);
        NavigationHandlerUtil.assertNotAlreadyRedirect((FacesContext)context);
        super.redirect(context, externalContext, redirectPath, newViewId);
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        super.handleNavigation(context, fromAction, outcome);
        if (context.getResponseComplete()) {
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        String viewId = context.getViewRoot().getViewId();
        String path = this.calcPathFromOutcome(context, viewId, outcome);
        if (path == null) {
            return;
        }
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        if (!PortletUtil.isPortlet((FacesContext)context)) {
            String redirectPath = this.getRedirectActionPath(context, viewHandler, path);
            this.redirect(context, externalContext, redirectPath, path);
        } else {
            RedirectScope.setRedirectingPath((FacesContext)context, (String)path);
            this.pagePersistence.save(context, path);
            if (PortletUtil.isRender((FacesContext)context)) {
                context.setResponseWriter(context.getResponseWriter().cloneWithWriter((Writer)new OutputStreamWriter(new ByteArrayOutputStream())));
            }
            context.responseComplete();
            context.renderResponse();
        }
    }

    protected String calcPathFromOutcome(FacesContext context, String viewId, String outcome) {
        if (outcome == null) {
            return null;
        }
        if (!this.namingConvention.isValidViewRootPath(viewId)) {
            return viewId;
        }
        int pos = viewId.lastIndexOf(47);
        int pos2 = viewId.lastIndexOf(46);
        String pathFirst = viewId.substring(0, pos + 1);
        String pathLast = viewId.substring(pos2);
        String[] names = StringUtil.split((String)outcome, (String)"_");
        String suffix = this.htmlSuffix.getSuffix(context);
        if (names.length == 1) {
            String path = pathFirst + outcome + suffix + pathLast;
            InputStream is = ServletContextUtil.getResourceAsStream((ServletContext)this.servletContext, (String)path);
            if (is != null) {
                InputStreamUtil.close((InputStream)is);
                return path;
            }
            return pathFirst + outcome + pathLast;
        }
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < names.length; ++i) {
            buf.append(StringUtil.decapitalize((String)names[i]));
            if (i == names.length - 1) continue;
            buf.append("/");
        }
        pos = viewId.indexOf(47, 1);
        pathFirst = viewId.substring(0, pos + 1);
        String path = pathFirst + buf + suffix + pathLast;
        if (this.servletContext.getResourceAsStream(path) != null) {
            return path;
        }
        return pathFirst + buf + pathLast;
    }
}

