/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.beans.util.BeanUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.extension.component.TForEach;
import org.seasar.teeda.extension.util.AdjustValueHolderUtil;

public class TForEachRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.ForEach";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.ForEach";

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        TForEach forEach = (TForEach)component;
        Object page = forEach.getPage(context);
        Object pageClone = ClassUtil.newInstance(page.getClass());
        BeanUtil.copyProperties((Object)page, (Object)pageClone);
        BeanDesc pageBeanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        Object[] items = forEach.getItems(context);
        int rowSize = items != null ? items.length : 0;
        for (int i = 0; i < rowSize; ++i) {
            forEach.enterRow(context, i);
            if (i < items.length) {
                forEach.processItem(pageBeanDesc, page, items[i], i);
            }
            super.encodeChildren(context, component);
            forEach.leaveRow(context);
        }
        BeanUtil.copyProperties((Object)pageClone, (Object)page);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        TForEach forEach = (TForEach)component;
        int rowSize = this.getRowSize(context, forEach);
        forEach.setRowSize(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            forEach.enterRow(context, i);
            this.decodeChildren(context, component);
            forEach.leaveRow(context);
        }
    }

    private int getRowSize(FacesContext context, TForEach forEach) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        Map reqParam = AdjustValueHolderUtil.adjustParamMap(paramMap);
        String clientId = AdjustValueHolderUtil.getAdjustedValue(forEach.getClientId(context));
        String namingPrefix = clientId + ':';
        int rowSize = -1;
        Iterator it = reqParam.keySet().iterator();
        while (it.hasNext()) {
            int pos;
            String name = (String)it.next();
            if (!name.startsWith(namingPrefix) || -1 >= (pos = name.indexOf(58, namingPrefix.length()))) continue;
            String num = name.substring(namingPrefix.length(), pos);
            try {
                int index = Integer.parseInt(num);
                rowSize = Math.max(rowSize, index);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return ++rowSize;
    }

    private void decodeChildren(FacesContext context, UIComponent component) {
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            child.processDecodes(context);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

