/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.LabelUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.UITitle;

public class TTitleRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Title";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Title";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        UITitle title = (UITitle)component;
        this.encodeTitleBegin(context, title);
    }

    protected void encodeTitleBegin(FacesContext context, UITitle title) throws IOException {
        String value;
        String lang;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("title", (UIComponent)title);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)title, (String)this.getIdForRender(context, (UIComponent)title));
        String dir = title.getDir();
        if (!StringUtil.isEmpty((String)dir)) {
            writer.writeAttribute("dir", (Object)dir, null);
        }
        if (!StringUtil.isEmpty((String)(lang = title.getLang()))) {
            writer.writeAttribute("lang", (Object)lang, null);
        }
        if (StringUtil.isEmpty((String)(value = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)title)))) {
            String key = title.getKey();
            String propertiesName = title.getPropertiesName();
            String defaultKey = title.getDefaultKey();
            String defaultPropertiesName = title.getDefaultPropertiesName();
            value = LabelUtil.getLabelValue((String)key, (String)propertiesName, (String)defaultKey, (String)defaultPropertiesName);
        }
        if (value != null) {
            writer.writeText((Object)value, null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTitleEnd(context, (UITitle)component);
    }

    protected void encodeTitleEnd(FacesContext context, UITitle title) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("title");
    }
}

