/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.extension.util.VirtualResource;

public class THtmlHeadRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlHead";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlHead";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("head", component);
        writer.write("\n");
        this.renderCssResources(context);
        this.renderJsResources(context);
        this.renderInlineCssResources(context);
        this.renderInlineJsResources(context);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("head");
        writer.write("\n");
    }

    protected void renderJsResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Set jsResources = VirtualResource.getJsResources(context);
        Iterator i = jsResources.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            this.renderIncludeJavaScript(writer, VirtualResource.convertVirtualPath(context, path));
            writer.write("\n");
        }
    }

    protected void renderInlineJsResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Collection values = VirtualResource.getInlineJsResourceValues(context);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            String script = (String)i.next();
            this.renderJavaScriptElement(writer, script);
            writer.write("\n");
        }
    }

    protected void renderCssResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Set cssResources = VirtualResource.getCssResources(context);
        Iterator i = cssResources.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            this.renderStyleSheet(writer, VirtualResource.convertVirtualPath(context, path));
            writer.write("\n");
        }
    }

    protected void renderInlineCssResources(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Collection values = VirtualResource.getInlineCssResourceValues(context);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            writer.write((String)i.next());
        }
    }
}

