/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.BigDecimalConversionUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.html.THtmlInputCommaText;
import org.seasar.teeda.extension.component.html.THtmlInputText;
import org.seasar.teeda.extension.render.html.AbstractInputExtendTextRenderer;

public class THtmlInputCommaTextRenderer
extends AbstractInputExtendTextRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlInputCommaText";
    private static final String DEFAULT_FRACTION = "0";
    private static final String JS_NAMESPACE_PREFIX = "Teeda.THtmlInputCommaText.";

    protected void doEncodeEndCustomize(FacesContext context, THtmlInputText htmlInputText) throws IOException {
        THtmlInputCommaTextRenderer.assertHtmlInputCommaText(htmlInputText);
        THtmlInputCommaText htmlInputCommaText = (THtmlInputCommaText)htmlInputText;
        ResponseWriter writer = context.getResponseWriter();
        Locale locale = context.getViewRoot().getLocale();
        String fraction = this.getFraction(htmlInputCommaText);
        String groupingSeparator = this.getGroupingSeparator(htmlInputCommaText, locale);
        String fractionSeparator = this.getFractionSeparator(htmlInputCommaText, locale);
        this.renderOnfocus(htmlInputCommaText, writer, groupingSeparator);
        this.renderOnblur(htmlInputCommaText, writer, fraction, groupingSeparator, fractionSeparator);
        this.renderOnkeydown(htmlInputCommaText, writer, fraction, fractionSeparator);
        this.renderOnkeypress(htmlInputCommaText, writer, fraction, fractionSeparator);
        this.renderOnkeyup(htmlInputCommaText, writer);
        this.renderStyle(htmlInputCommaText, writer);
        this.renderStyleClass(context, htmlInputCommaText, writer);
    }

    protected static void assertHtmlInputCommaText(THtmlInputText htmlInputText) {
        if (!(htmlInputText instanceof THtmlInputCommaText)) {
            throw new IllegalStateException();
        }
    }

    protected String getValue(FacesContext context, UIComponent component) {
        String value = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)component);
        if (StringUtil.isEmpty((String)value)) {
            return value;
        }
        THtmlInputCommaText htmlInputCommaText = (THtmlInputCommaText)component;
        try {
            Locale locale = context.getViewRoot().getLocale();
            String fraction = this.getFractionSeparator(htmlInputCommaText, locale);
            String groupingSeparator = this.getGroupingSeparator(htmlInputCommaText, locale);
            if (value.indexOf(groupingSeparator) > 0) {
                value = StringUtil.replace((String)value, (String)groupingSeparator, (String)"");
            }
            DecimalFormat df = new DecimalFormat();
            int pos = value.indexOf(fraction);
            if (pos < 0) {
                BigDecimal bd = BigDecimalConversionUtil.toBigDecimal((Object)value);
                return df.format(bd);
            }
            boolean isMinus = value.startsWith("-");
            String intPart = isMinus ? value.substring(1, pos) : value.substring(0, pos);
            String fractPart = value.substring(pos);
            BigDecimal bd = BigDecimalConversionUtil.toBigDecimal((Object)intPart);
            String s = df.format(bd);
            String ret = s + fractPart;
            return isMinus ? "-" + ret : ret;
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    private String getGroupingSeparator(THtmlInputCommaText htmlInputCommaText, Locale locale) {
        String groupingSeparator = htmlInputCommaText.getGroupingSeparator();
        if (StringUtil.isEmpty((String)groupingSeparator)) {
            groupingSeparator = NumberConversionUtil.findGroupingSeparator((Locale)locale);
        }
        return groupingSeparator;
    }

    private String getFractionSeparator(THtmlInputCommaText htmlInputCommaText, Locale locale) {
        String fractionSeparator = htmlInputCommaText.getFractionSeparator();
        if (StringUtil.isEmpty((String)fractionSeparator)) {
            fractionSeparator = NumberConversionUtil.findDecimalSeparator((Locale)locale);
        }
        return fractionSeparator;
    }

    private String getFraction(THtmlInputCommaText htmlInputCommaText) {
        String fraction = htmlInputCommaText.getFraction();
        if (StringUtil.isEmpty((String)fraction)) {
            fraction = DEFAULT_FRACTION;
        }
        return fraction;
    }

    protected void renderStyle(THtmlInputCommaText htmlInputCommaText, ResponseWriter writer) throws IOException {
        String style = this.createStyleAttribute(htmlInputCommaText);
        if (StringUtil.isNotBlank((String)style)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"style", (Object)style);
        }
    }

    protected String createStyleAttribute(THtmlInputCommaText htmlInputCommaText) {
        String style = THtmlInputCommaTextRenderer.appendSemiColonIfNeed(htmlInputCommaText.getStyle());
        String s = "ime-mode:disabled;";
        if (StringUtil.contains((String)style, (String)"ime-mode:disabled;")) {
            return style;
        }
        return style + "ime-mode:disabled;";
    }

    protected void renderOnfocus(THtmlInputCommaText htmlInputCommaText, ResponseWriter writer, String groupingSeparator) throws IOException {
        String target;
        String onfocus = THtmlInputCommaTextRenderer.appendSemiColonIfNeed(htmlInputCommaText.getOnfocus());
        if (!onfocus.endsWith(target = "Teeda.THtmlInputCommaText.removeComma(this, '" + groupingSeparator + "');this.select();")) {
            onfocus = onfocus + target;
        }
        if (StringUtil.isNotBlank((String)onfocus)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onfocus", (Object)onfocus);
        }
    }

    protected void renderOnblur(THtmlInputCommaText htmlInputCommaText, ResponseWriter writer, String fraction, String groupingSeparator, String fractionSeparator) throws IOException {
        String onblur = this.createOnblurAttribute(htmlInputCommaText, fraction, groupingSeparator, fractionSeparator);
        if (StringUtil.isNotBlank((String)onblur)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onblur", (Object)onblur);
        }
    }

    protected String createOnblurAttribute(THtmlInputCommaText htmlInputCommaText, String fraction, String groupingSeparator, String fractionSeparator) {
        String s;
        String onblur = THtmlInputCommaTextRenderer.appendSemiColonIfNeed(htmlInputCommaText.getOnblur());
        if (StringUtil.contains((String)onblur, (String)(s = "Teeda.THtmlInputCommaText.convertByKey(this);Teeda.THtmlInputCommaText.addComma(this, " + fraction + ", '" + groupingSeparator + "', '" + fractionSeparator + "');"))) {
            return onblur;
        }
        return onblur + s;
    }

    protected void renderOnkeydown(THtmlInputCommaText htmlInputCommaText, ResponseWriter writer, String fraction, String fractionSeparator) throws IOException {
        String onkeydown = THtmlInputCommaTextRenderer.appendSemiColonIfNeed(htmlInputCommaText.getOnkeydown());
        this.renderKeycheckEvent(writer, "onkeydown", onkeydown, fraction, fractionSeparator);
    }

    protected void renderOnkeypress(THtmlInputCommaText htmlInputCommaText, ResponseWriter writer, String fraction, String fractionSeparator) throws IOException {
        String onkeypress = THtmlInputCommaTextRenderer.appendSemiColonIfNeed(htmlInputCommaText.getOnkeypress());
        this.renderKeycheckEvent(writer, "onkeypress", onkeypress, fraction, fractionSeparator);
    }

    private void renderKeycheckEvent(ResponseWriter writer, String attributeName, String target, String fraction, String fractionSeparator) throws IOException {
        String script = "return Teeda.THtmlInputCommaText.keycheckForNumber(event, this, " + fraction + ", '" + fractionSeparator + "');";
        if (!target.endsWith(script)) {
            target = target + script;
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)attributeName, (Object)target);
        }
    }

    protected void renderOnkeyup(THtmlInputCommaText htmlInputCommaText, ResponseWriter writer) throws IOException {
        String onkeyup = THtmlInputCommaTextRenderer.appendSemiColonIfNeed(htmlInputCommaText.getOnkeyup());
        String script = "Teeda.THtmlInputCommaText.convertByKey(this);";
        if (!onkeyup.endsWith("Teeda.THtmlInputCommaText.convertByKey(this);")) {
            onkeyup = onkeyup + "Teeda.THtmlInputCommaText.convertByKey(this);";
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"onkeyup", (Object)onkeyup);
        }
    }

    protected IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = super.buildIgnoreComponent();
        ignore.addAttributeName("style");
        ignore.addAttributeName("styleClass");
        ignore.addAttributeName("onfocus");
        ignore.addAttributeName("onblur");
        ignore.addAttributeName("onkeydown");
        ignore.addAttributeName("onkeypress");
        ignore.addAttributeName("onkeyup");
        ignore.addAttributeName("disabled");
        ignore.addAttributeName("fraction");
        ignore.addAttributeName("groupingSeparator");
        ignore.addAttributeName("fractionSeparator");
        return ignore;
    }

    protected String getScriptKey() {
        return THtmlInputCommaText.class.getName();
    }
}

