/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.WindowIdUtil;
import javax.servlet.ServletContext;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.HtmlOutputLinkRenderer;
import org.seasar.teeda.core.render.html.support.PortletUrlBuilder;
import org.seasar.teeda.core.render.html.support.UrlBuilder;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.ServletContextUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.html.HtmlSuffix;

public class THtmlOutputLinkRenderer
extends HtmlOutputLinkRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Link";
    private HtmlSuffix htmlSuffix;
    private static final Logger logger = Logger.getLogger((Class)THtmlOutputLinkRenderer.class);

    protected String buildHref(FacesContext context, HtmlOutputLink htmlOutputLink, String encoding) throws IOException {
        String base = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)htmlOutputLink);
        if (PortletUtil.isPortlet((FacesContext)context)) {
            if (htmlOutputLink.getId().startsWith("go") || htmlOutputLink.getId().startsWith("jump")) {
                PortletUrlBuilder urlBuilder = new PortletUrlBuilder();
                urlBuilder.setBase(base);
                Iterator it = htmlOutputLink.getChildren().iterator();
                while (it.hasNext()) {
                    UIComponent child = (UIComponent)it.next();
                    if (!(child instanceof UIParameter)) continue;
                    UIParameter parameter = (UIParameter)child;
                    String name = parameter.getName();
                    String value = this.toBlankIfNull(parameter.getValue());
                    urlBuilder.add(name, value);
                }
                return context.getExternalContext().encodeResourceURL(urlBuilder.build());
            }
            return super.buildHref(context, htmlOutputLink, encoding);
        }
        UrlBuilder urlBuilder = new UrlBuilder();
        String sufiixedBase = this.getSuffixedBase(context, base);
        urlBuilder.setBase(sufiixedBase);
        Iterator it = htmlOutputLink.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            String convertedValue = this.convertDateIfNeed(parameter.getValue(), context, encoding);
            urlBuilder.add(parameter.getName(), convertedValue);
        }
        if (WindowIdUtil.isNewWindowTarget((String)htmlOutputLink.getTarget())) {
            urlBuilder.add("newwindow", "true");
        }
        return context.getExternalContext().encodeResourceURL(urlBuilder.build());
    }

    protected void renderHref(FacesContext context, ResponseWriter writer, String href) throws IOException {
        writer.writeAttribute("href", (Object)href, null);
    }

    protected String convertDateIfNeed(Object value, FacesContext context, String encoding) {
        if (value == null) {
            return "";
        }
        String ret = null;
        try {
            if (value instanceof Date) {
                Locale locale = context.getViewRoot().getLocale();
                SimpleDateFormat dateFormat = DateConversionUtil.getY4DateFormat((Locale)locale);
                ret = URLEncoder.encode(dateFormat.format((Date)value), encoding);
            } else {
                ret = value instanceof String ? URLEncoder.encode(value.toString(), encoding) : value.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.info((Object)e);
            ret = value.toString();
        }
        return ret;
    }

    public void setHtmlSuffix(HtmlSuffix htmlSuffix) {
        this.htmlSuffix = htmlSuffix;
    }

    protected String getSuffixedBase(FacesContext context, String base) {
        if (this.htmlSuffix == null) {
            return base;
        }
        String value = base;
        String suffix = this.htmlSuffix.getSuffix(context);
        int lastIndexOf = base.lastIndexOf(".");
        if (lastIndexOf >= 0) {
            String postfix = base.substring(lastIndexOf);
            String viewId = context.getViewRoot().getViewId();
            String viewIdPrefix = viewId.substring(0, viewId.lastIndexOf("/") + 1);
            if (base.startsWith("../")) {
                String[] split = StringUtil.split((String)viewIdPrefix, (String)"/");
                String s = base;
                for (int i = 0; i < split.length; ++i) {
                    if (s.indexOf("../") < 0) continue;
                    s = s.replaceFirst("\\.\\./", split[i] + "/");
                }
                String prefix = "/" + s.substring(0, s.lastIndexOf("."));
                value = prefix + suffix + postfix;
            } else if (base.startsWith("./")) {
                String s = StringUtil.replace((String)base, (String)"./", (String)viewIdPrefix);
                value = s.substring(0, s.lastIndexOf(".")) + suffix + postfix;
            } else {
                String prefix = base.substring(0, lastIndexOf);
                if (!prefix.startsWith("/")) {
                    prefix = "/" + prefix;
                }
                value = prefix + suffix + postfix;
            }
            value = this.hasActualResource(context, value) ? this.getResourceURL(context, value) : base;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasActualResource(FacesContext context, String value) {
        ExternalContext externalContext = context.getExternalContext();
        ServletContext servletContext = (ServletContext)externalContext.getContext();
        InputStream is = ServletContextUtil.getResourceAsStream((ServletContext)servletContext, (String)value);
        try {
            boolean bl = is != null;
            return bl;
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
    }

    protected String getResourceURL(FacesContext context, String path) {
        return context.getApplication().getViewHandler().getResourceURL(context, path);
    }
}

