/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.UIComponentUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.UIValueUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.html.THtmlRadioItem;

public class THtmlRadioItemRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Radio";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlRadioItem";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public THtmlRadioItemRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("type");
        this.ignoreComponent.addAttributeName("name");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("checked");
        this.ignoreComponent.addAttributeName("itemValue");
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        HtmlSelectOneRadio parent = (HtmlSelectOneRadio)UIComponentUtil.findParent((UIComponent)component, (Class)HtmlSelectOneRadio.class);
        String valueStr = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)parent);
        String clientId = parent.getClientId(context);
        Converter converter = RendererUtil.findConverter((FacesContext)context, (UIOutput)parent);
        THtmlRadioItem htmlInputRadio = (THtmlRadioItem)component;
        Object itemValue = htmlInputRadio.getValue();
        String itemValueStr = UIValueUtil.getValueAsString((FacesContext)context, (UIComponent)component, (Object)itemValue, (Converter)converter);
        boolean checked = valueStr.equals(itemValueStr);
        boolean disabled = parent.isDisabled() || htmlInputRadio.isDisabled();
        this.renderRadio(context, htmlInputRadio, itemValueStr, clientId, checked, disabled);
    }

    protected void renderRadio(FacesContext context, THtmlRadioItem component, String value, String name, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)component);
        writer.writeAttribute("type", (Object)"radio", null);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)component, (String)this.getIdForRender(context, (UIComponent)component));
        writer.writeAttribute("name", (Object)name, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (!StringUtil.isEmpty((String)value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        this.renderRemainAttributes((UIComponent)component, writer, this.ignoreComponent);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        this.assertNotNull(context, component);
        return RendererUtil.getConvertedUIOutputValue((FacesContext)context, (UIOutput)((UIOutput)component), (Object)submittedValue);
    }
}

