/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractInputRenderer;
import org.seasar.teeda.core.render.EncodeConverter;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlItemsSaveHidden;
import org.seasar.teeda.extension.component.html.THtmlTreeHidden;

public class THtmlTreeHiddenRenderer
extends AbstractInputRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.TreeHidden";
    private EncodeConverter encodeConverter;
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public THtmlTreeHiddenRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.getDecoder().decode(context, component);
        this.decodeTHtmlTreeHidden(context, (THtmlTreeHidden)component);
    }

    protected void decodeTHtmlTreeHidden(FacesContext context, THtmlTreeHidden hidden) {
        String s = (String)hidden.getSubmittedValue();
        if (StringUtil.isEmpty((String)s)) {
            return;
        }
        Object deserialize = this.deserialize(s);
        Object rebuildValue = HotdeployUtil.rebuildValue((Object)deserialize);
        hidden.setValue(rebuildValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlTreeHiddenEnd(context, (THtmlTreeHidden)component);
    }

    protected void encodeHtmlTreeHiddenEnd(FacesContext context, THtmlTreeHidden htmlTreeHidden) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", (UIComponent)htmlTreeHidden);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"type", (Object)"hidden");
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)htmlTreeHidden, (String)this.getIdForRender(context, (UIComponent)htmlTreeHidden));
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"name", (Object)htmlTreeHidden.getClientId(context));
        String value = this.getValueForRender(context, htmlTreeHidden);
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"value", (Object)value);
        this.renderRemainAttributes((UIComponent)htmlTreeHidden, writer, this.ignoreComponent);
        writer.endElement("input");
    }

    protected String getValueForRender(FacesContext context, THtmlItemsSaveHidden htmlInputHidden) {
        Object submittedValue = htmlInputHidden.getSubmittedValue();
        if (submittedValue != null) {
            if (submittedValue instanceof String) {
                return (String)submittedValue;
            }
            return submittedValue.toString();
        }
        Object value = htmlInputHidden.getValue();
        if (value == null) {
            return "";
        }
        return this.serialize(value);
    }

    protected String serialize(Object target) {
        return this.encodeConverter.getAsEncodeString(target);
    }

    protected Object deserialize(String value) {
        return this.encodeConverter.getAsDecodeObject(value);
    }

    public EncodeConverter getEncodeConverter() {
        return this.encodeConverter;
    }

    public void setEncodeConverter(EncodeConverter encodeConverter) {
        this.encodeConverter = encodeConverter;
    }
}

