/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.seasar.extension.dbcp.ConnectionPool;
import org.seasar.extension.dbcp.ConnectionWrapper;
import org.seasar.extension.dbcp.impl.XAResourceWrapperImpl;
import org.seasar.extension.jdbc.impl.PreparedStatementWrapper;
import org.seasar.framework.exception.SSQLException;
import org.seasar.framework.log.Logger;

public class ConnectionWrapperImpl
implements ConnectionWrapper {
    private static final Logger logger_ = Logger.getLogger((Class)ConnectionWrapperImpl.class);
    private XAConnection xaConnection_;
    private Connection physicalConnection_;
    private XAResource xaResource_;
    private ConnectionPool connectionPool_;
    private boolean closed_ = false;
    private boolean localTx_;

    public ConnectionWrapperImpl(XAConnection xaConnection, ConnectionPool connectionPool, boolean localTx) throws SQLException {
        this.xaConnection_ = xaConnection;
        this.physicalConnection_ = xaConnection.getConnection();
        this.xaResource_ = new XAResourceWrapperImpl(xaConnection.getXAResource(), this);
        this.connectionPool_ = connectionPool;
        this.localTx_ = localTx;
    }

    public Connection getPhysicalConnection() {
        return this.physicalConnection_;
    }

    public XAResource getXAResource() {
        return this.xaResource_;
    }

    public XAConnection getXAConnection() {
        return this.xaConnection_;
    }

    public void init(boolean localTx) {
        this.closed_ = false;
        this.localTx_ = localTx;
    }

    public void cleanup() {
        this.closed_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReally() {
        if (this.xaConnection_ == null) {
            return;
        }
        this.closed_ = true;
        try {
            this.xaConnection_.close();
            logger_.log("DSSR0001", null);
        }
        catch (SQLException ex) {
            logger_.log((Throwable)ex);
        }
        finally {
            this.xaConnection_ = null;
        }
        try {
            if (!this.physicalConnection_.isClosed()) {
                this.physicalConnection_.close();
            }
        }
        catch (SQLException ex) {
            logger_.log((Throwable)ex);
        }
    }

    private void assertOpened() throws SQLException {
        if (this.closed_) {
            throw new SSQLException("ESSR0062", null);
        }
    }

    private void assertLocalTx() throws SQLException {
        if (!this.localTx_) {
            throw new SSQLException("ESSR0366", null);
        }
    }

    public void release() throws SQLException {
        this.connectionPool_.release(this);
    }

    public Statement createStatement() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.nativeSQL(sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getMetaData();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setReadOnly(readOnly);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setCatalog(catalog);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public String getCatalog() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void close() throws SQLException {
        if (this.closed_) {
            return;
        }
        if (this.localTx_) {
            this.connectionPool_.checkIn(this);
        }
        logger_.log("DSSR0002", null);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setTransactionIsolation(level);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void clearWarnings() throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void commit() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.commit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void rollback() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.rollback();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertOpened();
        if (autoCommit) {
            this.assertLocalTx();
        }
        try {
            this.physicalConnection_.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        this.assertOpened();
        try {
            this.physicalConnection_.setHoldability(holdability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public int getHoldability() throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            return this.physicalConnection_.setSavepoint(name);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.assertOpened();
        this.assertLocalTx();
        try {
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw ex;
        }
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.assertOpened();
        try {
            return this.physicalConnection_.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, autoGeneratedKeys), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, columnIndexes), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.assertOpened();
        try {
            return new PreparedStatementWrapper(this.physicalConnection_.prepareStatement(sql, columnNames), sql);
        }
        catch (SQLException ex) {
            this.release();
            throw this.wrapException(ex, sql);
        }
    }

    private SQLException wrapException(SQLException e, String sql) {
        return new SSQLException("ESSR0072", new Object[]{sql}, e.getSQLState(), e.getErrorCode(), (Throwable)e, sql);
    }
}

