/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbsession;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.seasar.extension.dbsession.DbHttpSessionWrapper;
import org.seasar.extension.dbsession.DbSessionStateManager;

public class DbHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest request;
    private DbSessionStateManager sessionStateManager;
    private DbHttpSessionWrapper sessionWrapper;

    public DbHttpServletRequestWrapper(HttpServletRequest request, DbSessionStateManager sessionStateManager) {
        super(request);
        this.request = request;
        this.sessionStateManager = sessionStateManager;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.sessionWrapper != null) {
            return this.sessionWrapper;
        }
        HttpSession session = this.request.getSession(create);
        if (session == null) {
            return null;
        }
        this.sessionWrapper = new DbHttpSessionWrapper(session, this.sessionStateManager);
        return this.sessionWrapper;
    }

    public DbHttpSessionWrapper getSessionWrapper() {
        return this.sessionWrapper;
    }
}

