/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbsession;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.seasar.extension.dbsession.DbSessionState;
import org.seasar.extension.dbsession.DbSessionStateManager;

public class DbHttpSessionWrapper
implements HttpSession {
    private HttpSession session;
    private DbSessionStateManager sessionStateManager;
    private DbSessionState sessionState;

    public DbHttpSessionWrapper(HttpSession session, DbSessionStateManager sessionStateManager) {
        this.session = session;
        this.sessionStateManager = sessionStateManager;
    }

    public DbSessionState getSessionState() {
        return this.sessionState;
    }

    public Object getAttribute(String name) {
        this.setupSessionState();
        return this.sessionState.getAttribute(name);
    }

    protected synchronized void setupSessionState() {
        if (this.sessionState == null) {
            this.sessionState = this.sessionStateManager.loadState(this.session.getId());
        }
    }

    public Enumeration getAttributeNames() {
        this.setupSessionState();
        return this.sessionState.getAttributeNames();
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        return this.session.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        ArrayList list = new ArrayList();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.setupSessionState();
        this.sessionState.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }
}

