/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbsession;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.seasar.extension.dbsession.DbHttpServletRequestWrapper;
import org.seasar.extension.dbsession.DbHttpSessionWrapper;
import org.seasar.extension.dbsession.DbSessionState;
import org.seasar.extension.dbsession.DbSessionStateManager;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class DbSessionFilter
implements Filter {
    private DbSessionStateManager sessionStateManager;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DbSessionStateManager ssm = this.getSessionStateManager();
        DbHttpServletRequestWrapper requestWrapper = new DbHttpServletRequestWrapper((HttpServletRequest)request, ssm);
        try {
            chain.doFilter((ServletRequest)requestWrapper, response);
            Object var7_6 = null;
            DbHttpSessionWrapper sessionWrapper = requestWrapper.getSessionWrapper();
            if (sessionWrapper == null) {
                return;
            }
            DbSessionState sessionState = sessionWrapper.getSessionState();
            if (sessionState != null) {
                ssm.updateState(sessionWrapper.getId(), sessionState);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DbHttpSessionWrapper sessionWrapper = requestWrapper.getSessionWrapper();
            if (sessionWrapper == null) {
                return;
            }
            DbSessionState sessionState = sessionWrapper.getSessionState();
            if (sessionState != null) {
                ssm.updateState(sessionWrapper.getId(), sessionState);
            }
            throw throwable;
        }
    }

    protected DbSessionStateManager getSessionStateManager() {
        if (this.sessionStateManager == null) {
            S2Container container = SingletonS2ContainerFactory.getContainer();
            this.sessionStateManager = (DbSessionStateManager)container.getComponent((Object)DbSessionStateManager.class);
        }
        return this.sessionStateManager;
    }
}

