/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbsession;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.SerializeUtil;

public class DbSessionState {
    private Map binaryData;
    private Map accessedData;

    public DbSessionState(Map binaryData) {
        this.binaryData = binaryData;
        this.accessedData = new HashMap(Math.max(binaryData.size(), 20));
    }

    public synchronized Object getAttribute(String name) {
        if (this.accessedData.containsKey(name)) {
            return this.accessedData.get(name);
        }
        if (this.binaryData.containsKey(name)) {
            byte[] binary = (byte[])this.binaryData.get(name);
            Object value = SerializeUtil.fromBinaryToObject((byte[])binary);
            this.accessedData.put(name, value);
            return value;
        }
        return null;
    }

    public Enumeration getAttributeNames() {
        LinkedHashSet set = new LinkedHashSet();
        Iterator i = this.accessedData.keySet().iterator();
        while (i.hasNext()) {
            set.add(i.next());
        }
        i = this.binaryData.keySet().iterator();
        while (i.hasNext()) {
            set.add(i.next());
        }
        return new EnumerationAdapter(set.iterator());
    }

    public Enumeration getAccessedAttributeNames() {
        return new EnumerationAdapter(this.accessedData.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.accessedData.put(name, value);
    }

    public boolean needInsert(String name) {
        if (!this.accessedData.containsKey(name)) {
            return false;
        }
        Object value = this.accessedData.get(name);
        return value != null && !this.binaryData.containsKey(name);
    }

    public boolean needUpdate(String name) {
        if (!this.accessedData.containsKey(name)) {
            return false;
        }
        Object value = this.accessedData.get(name);
        return value != null && this.binaryData.containsKey(name);
    }

    public boolean needDelete(String name) {
        if (!this.accessedData.containsKey(name)) {
            return false;
        }
        Object value = this.accessedData.get(name);
        return value == null && this.binaryData.containsKey(name);
    }
}

