/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbsession.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.extension.dbsession.DbSessionState;
import org.seasar.extension.dbsession.DbSessionStateManager;
import org.seasar.extension.jdbc.impl.BasicBatchHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.impl.BasicUpdateHandler;
import org.seasar.extension.jdbc.impl.MapListResultSetHandler;
import org.seasar.framework.util.SerializeUtil;

public class DbSessionStateManagerImpl
implements DbSessionStateManager {
    private static final String SELECT_SQL = "select name, value from s2session where session_id = ?";
    private static final String INSERT_SQL = "insert into s2session values(?, ?, ?, ?)";
    private static final String UPDATE_SQL = "update s2session set value = ?, last_access = ? where session_id = ? and name = ?";
    private static final String DELETE_SQL = "delete from s2session where session_id = ? and name = ?";
    private static final String DELETE_ALL_SQL = "delete from s2session where session_id = ?";
    private DataSource dataSource;

    public DbSessionStateManagerImpl() {
    }

    public DbSessionStateManagerImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DbSessionState loadState(String sessionId) {
        BasicSelectHandler handler = new BasicSelectHandler(this.dataSource, SELECT_SQL, new MapListResultSetHandler());
        List result = (List)handler.execute(new String[]{sessionId});
        HashMap binaryData = new HashMap(result.size());
        for (int i = 0; i < result.size(); ++i) {
            Map m = (Map)result.get(i);
            binaryData.put(m.get("name"), m.get("value"));
        }
        return new DbSessionState(binaryData);
    }

    public void removeState(String sessionId) {
        BasicUpdateHandler handler = new BasicUpdateHandler(this.dataSource, DELETE_ALL_SQL);
        handler.execute(new Object[]{sessionId});
    }

    public void updateState(String sessionId, DbSessionState sessionState) {
        ArrayList<Object[]> insertedData = new ArrayList<Object[]>();
        ArrayList<Object[]> updatedData = new ArrayList<Object[]>();
        ArrayList<Object[]> deletedData = new ArrayList<Object[]>();
        Timestamp lastAccess = new Timestamp(new Date().getTime());
        Enumeration e = sessionState.getAccessedAttributeNames();
        while (e.hasMoreElements()) {
            byte[] value;
            String name = (String)e.nextElement();
            if (sessionState.needInsert(name)) {
                value = SerializeUtil.fromObjectToBinary((Object)sessionState.getAttribute(name));
                insertedData.add(new Object[]{sessionId, name, value, lastAccess});
                continue;
            }
            if (sessionState.needUpdate(name)) {
                value = SerializeUtil.fromObjectToBinary((Object)sessionState.getAttribute(name));
                updatedData.add(new Object[]{value, lastAccess, sessionId, name});
                continue;
            }
            if (!sessionState.needDelete(name)) continue;
            deletedData.add(new Object[]{sessionId, name});
        }
        this.executeBatch(INSERT_SQL, insertedData);
        this.executeBatch(UPDATE_SQL, updatedData);
        this.executeBatch(DELETE_SQL, deletedData);
    }

    protected void executeBatch(String sql, List data) {
        if (data.size() == 0) {
            return;
        }
        BasicBatchHandler handler = new BasicBatchHandler(this.dataSource, sql);
        handler.execute(data);
    }
}

