/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.builder.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.seasar.extension.dxo.builder.impl.AbstractDxoCommandBuilder;
import org.seasar.extension.dxo.command.DxoCommand;
import org.seasar.extension.dxo.command.impl.MapToBeanDxoCommand;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.util.DxoUtil;
import org.seasar.framework.util.MethodUtil;

public class MapToBeanDxoCommandBuilder
extends AbstractDxoCommandBuilder {
    protected ConverterFactory converterFactory;

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public DxoCommand createDxoCommand(Class dxoClass, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            return null;
        }
        Class<?> sourceType = parameterTypes[0];
        Class sourceElementClass = MethodUtil.getElementTypeOfListFromParameterType((Method)method, (int)0);
        Class<?> destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        Class destElementClass = DxoUtil.getElementTypeOfList(method);
        if (sourceType.isArray()) {
            Class<?> elementType;
            if (Map.class.isAssignableFrom(elementType = sourceType.getComponentType())) {
                if (destType.isArray()) {
                    return new MapToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destType.getComponentType());
                }
                if (List.class.isAssignableFrom(destType) && destElementClass != null) {
                    return new MapToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destElementClass);
                }
            }
        } else if (List.class.isAssignableFrom(sourceType)) {
            if (sourceElementClass != null && Map.class.isAssignableFrom(sourceElementClass)) {
                if (destType.isArray()) {
                    return new MapToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destType.getComponentType());
                }
                if (List.class.isAssignableFrom(destType)) {
                    return new MapToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destElementClass);
                }
            }
        } else if (Map.class.isAssignableFrom(sourceType) && !destType.isArray() && !List.class.isAssignableFrom(destType)) {
            return new MapToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destType);
        }
        return null;
    }
}

