/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.command.impl;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.extension.dxo.annotation.AnnotationReader;
import org.seasar.extension.dxo.command.impl.AbstractDxoCommand;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.util.DxoUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.OgnlUtil;

public class BeanToMapDxoCommand
extends AbstractDxoCommand {
    protected Object parsedExpression;
    protected boolean excludeNull;
    protected Class valueType;

    public BeanToMapDxoCommand(Class dxoClass, Method method, ConverterFactory converterFactory, AnnotationReader annotationReader) {
        this(dxoClass, method, converterFactory, annotationReader, null);
    }

    public BeanToMapDxoCommand(Class dxoClass, Method method, ConverterFactory converterFactory, AnnotationReader annotationReader, String expression) {
        super(dxoClass, method, converterFactory, annotationReader);
        if (expression != null) {
            this.parsedExpression = DxoUtil.parseMap(expression);
        }
        this.excludeNull = annotationReader.isExcludeNull(dxoClass, method);
        this.valueType = DxoUtil.getValueTypeOfTargetMap(method);
        if (this.valueType == Object.class) {
            this.valueType = null;
        }
    }

    protected Object convertScalar(Object source) {
        Map dest;
        if (this.parsedExpression != null) {
            dest = (Map)OgnlUtil.getValue((Object)this.parsedExpression, (Object)source);
        } else {
            String expression = this.createConversionRule(source.getClass());
            dest = (Map)OgnlUtil.getValue((Object)DxoUtil.parseMap(expression), (Object)source);
        }
        if (this.excludeNull) {
            this.removeNullEntry(dest);
        }
        if (this.valueType == null) {
            return dest;
        }
        return this.convertValueType(dest, this.createContext(source));
    }

    protected void convertScalar(Object source, Object dest) {
        ((Map)dest).putAll((Map)this.convertScalar(source));
    }

    protected void removeNullEntry(Map map) {
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != null) continue;
            it.remove();
        }
    }

    protected Map convertValueType(Map from, ConversionContext context) {
        LinkedHashMap to = new LinkedHashMap();
        Iterator it = from.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || this.valueType.isInstance(value)) {
                to.put(key, value);
                continue;
            }
            Converter converter = this.converterFactory.getConverter(value.getClass(), this.valueType);
            to.put(key, converter.convert(value, this.valueType, context));
        }
        return to;
    }

    protected Class getDestElementType() {
        return Map.class;
    }

    protected String createConversionRule(Class sourceType) {
        StringBuffer buf = new StringBuffer(100);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)sourceType);
        int propertySize = beanDesc.getPropertyDescSize();
        for (int i = 0; i < propertySize; ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            if (!propertyDesc.hasReadMethod()) continue;
            String propertyName = propertyDesc.getPropertyName();
            buf.append("'").append(propertyName).append("': ").append(propertyName).append(", ");
        }
        if (propertySize > 0) {
            buf.setLength(buf.length() - 2);
        }
        return new String(buf);
    }
}

