/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import [Ljava.lang.Object;;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.Converter;
import org.seasar.extension.dxo.converter.ConverterFactory;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;

public class ArrayConverter
extends AbstractConverter {
    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return Object;.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        if (destClass.isAssignableFrom(source.getClass())) {
            return source;
        }
        if (source.getClass().isArray()) {
            return this.toArray(destClass.getComponentType(), (Object[])source, context);
        }
        if (source instanceof Collection) {
            return this.toArray(destClass.getComponentType(), (Collection)source, context);
        }
        Object[] result = (Object[])Array.newInstance(destClass.getComponentType(), 1);
        result[0] = source;
        return result;
    }

    protected Object toArray(Class componentType, Object[] source, ConversionContext context) {
        int length = source.length;
        Object[] result = (Object[])Array.newInstance(componentType, length);
        if (length == 0) {
            return result;
        }
        ConverterFactory converterFactory = context.getConverterFactory();
        for (int i = 0; i < length; ++i) {
            Object sourceElement = source[i];
            Converter converter = converterFactory.getConverter(sourceElement.getClass(), componentType);
            result[i] = converter.convert(sourceElement, componentType, context);
        }
        return result;
    }

    protected Object toArray(Class componentType, Collection source, ConversionContext context) {
        int length = source.size();
        Object[] result = (Object[])Array.newInstance(componentType, length);
        if (length == 0) {
            return result;
        }
        ConverterFactory converterFactory = context.getConverterFactory();
        int i = 0;
        Iterator it = source.iterator();
        while (it.hasNext()) {
            Object sourceElement = it.next();
            Converter converter = converterFactory.getConverter(sourceElement.getClass(), componentType);
            result[i] = converter.convert(sourceElement, componentType, context);
            ++i;
        }
        return result;
    }
}

