/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.BatchHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicBatchHandler
extends BasicHandler
implements BatchHandler {
    private static Logger logger_ = Logger.getLogger((Class)BasicBatchHandler.class);
    private int batchSize_ = -1;

    public BasicBatchHandler() {
    }

    public BasicBatchHandler(DataSource dataSource, String sql) {
        this(dataSource, sql, -1);
    }

    public BasicBatchHandler(DataSource dataSource, String sql, int batchSize) {
        this(dataSource, sql, batchSize, BasicStatementFactory.INSTANCE);
    }

    public BasicBatchHandler(DataSource dataSource, String sql, int batchSize, StatementFactory statementFactory) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setBatchSize(batchSize);
        this.setStatementFactory(statementFactory);
    }

    public int getBatchSize() {
        return this.batchSize_;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize_ = batchSize;
    }

    public int execute(List list) throws SQLRuntimeException {
        if (list.size() == 0) {
            return 0;
        }
        Object[] args = (Object[])list.get(0);
        return this.execute(list, this.getArgTypes(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(List list, Class[] argTypes) throws SQLRuntimeException {
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, list, argTypes);
            return n;
        }
        finally {
            ConnectionUtil.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Connection connection, List list, Class[] argTypes) {
        PreparedStatement ps = this.prepareStatement(connection);
        int batchSize = this.batchSize_ > 0 ? this.batchSize_ : list.size();
        try {
            int j = 0;
            for (int i = 0; i < list.size(); ++i) {
                Object[] args = (Object[])list.get(i);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)this.getCompleteSql(args));
                }
                this.bindArgs(ps, args, argTypes);
                PreparedStatementUtil.addBatch((PreparedStatement)ps);
                if (j == batchSize - 1 || i == list.size() - 1) {
                    PreparedStatementUtil.executeBatch((PreparedStatement)ps);
                    j = 0;
                    continue;
                }
                ++j;
            }
            int n = list.size();
            return n;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }
}

