/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.UpdateHandler;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicUpdateHandler
extends BasicHandler
implements UpdateHandler {
    private static Logger logger_ = Logger.getLogger((Class)BasicUpdateHandler.class);

    public BasicUpdateHandler() {
    }

    public BasicUpdateHandler(DataSource dataSource, String sql) {
        super(dataSource, sql);
    }

    public BasicUpdateHandler(DataSource dataSource, String sql, StatementFactory statementFactory) {
        super(dataSource, sql, statementFactory);
    }

    public int execute(Object[] args) throws SQLRuntimeException {
        return this.execute(args, this.getArgTypes(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] args, Class[] argTypes) throws SQLRuntimeException {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)this.getCompleteSql(args));
        }
        Connection connection = this.getConnection();
        try {
            int n = this.execute(connection, args, argTypes);
            return n;
        }
        finally {
            ConnectionUtil.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Connection connection, Object[] args, Class[] argTypes) {
        PreparedStatement ps = this.prepareStatement(connection);
        try {
            this.bindArgs(ps, args, argTypes);
            int n = PreparedStatementUtil.executeUpdate((PreparedStatement)ps);
            return n;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }
}

