/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.BigDecimalType;
import org.seasar.extension.jdbc.types.BinaryStreamType;
import org.seasar.extension.jdbc.types.BinaryType;
import org.seasar.extension.jdbc.types.BooleanType;
import org.seasar.extension.jdbc.types.CharacterType;
import org.seasar.extension.jdbc.types.DoubleType;
import org.seasar.extension.jdbc.types.FloatType;
import org.seasar.extension.jdbc.types.IntegerType;
import org.seasar.extension.jdbc.types.LongType;
import org.seasar.extension.jdbc.types.ObjectType;
import org.seasar.extension.jdbc.types.ShortType;
import org.seasar.extension.jdbc.types.SqlDateType;
import org.seasar.extension.jdbc.types.StringType;
import org.seasar.extension.jdbc.types.TimeType;
import org.seasar.extension.jdbc.types.TimestampType;

public final class ValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType CHARACTER = new CharacterType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BINARY_STREAM = new BinaryStreamType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType OBJECT = new ObjectType();
    private static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static Map types_ = new HashMap();

    private ValueTypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerValueType(Class clazz, ValueType valueType) {
        Map map = types_;
        synchronized (map) {
            types_.put(clazz, valueType);
        }
    }

    public static ValueType getValueType(Object obj) {
        if (obj == null) {
            return OBJECT;
        }
        return ValueTypes.getValueType(obj.getClass());
    }

    public static ValueType getValueType(Class clazz) {
        for (Class c = clazz; c != null; c = c.getSuperclass()) {
            ValueType valueType = ValueTypes.getValueType0(c);
            if (valueType == null) continue;
            return valueType;
        }
        return OBJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValueType getValueType0(Class clazz) {
        Map map = types_;
        synchronized (map) {
            return (ValueType)types_.get(clazz);
        }
    }

    public static Class getType(int sqltype) {
        switch (sqltype) {
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 91: {
                return Timestamp.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return BYTE_ARRAY_CLASS;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 16: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    public static ValueType getValueType(int sqltype) {
        return ValueTypes.getValueType(ValueTypes.getType(sqltype));
    }

    static {
        ValueTypes.registerValueType(String.class, STRING);
        ValueTypes.registerValueType(Character.TYPE, CHARACTER);
        ValueTypes.registerValueType(Character.class, CHARACTER);
        ValueTypes.registerValueType(Short.TYPE, SHORT);
        ValueTypes.registerValueType(Short.class, SHORT);
        ValueTypes.registerValueType(Integer.TYPE, INTEGER);
        ValueTypes.registerValueType(Integer.class, INTEGER);
        ValueTypes.registerValueType(Long.TYPE, LONG);
        ValueTypes.registerValueType(Long.class, LONG);
        ValueTypes.registerValueType(Float.TYPE, FLOAT);
        ValueTypes.registerValueType(Float.class, FLOAT);
        ValueTypes.registerValueType(Double.TYPE, DOUBLE);
        ValueTypes.registerValueType(Double.class, DOUBLE);
        ValueTypes.registerValueType(BigDecimal.class, BIGDECIMAL);
        ValueTypes.registerValueType(Date.class, SQLDATE);
        ValueTypes.registerValueType(Time.class, TIME);
        ValueTypes.registerValueType(java.util.Date.class, TIMESTAMP);
        ValueTypes.registerValueType(Timestamp.class, TIMESTAMP);
        ValueTypes.registerValueType(Calendar.class, TIMESTAMP);
        ValueTypes.registerValueType(BYTE_ARRAY_CLASS, BINARY);
        ValueTypes.registerValueType(InputStream.class, BINARY_STREAM);
        ValueTypes.registerValueType(Boolean.TYPE, BOOLEAN);
        ValueTypes.registerValueType(Boolean.class, BOOLEAN);
        ValueTypes.registerValueType(Object.class, OBJECT);
    }
}

