/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.seasar.extension.jta.XAResourceWrapper;
import org.seasar.extension.jta.xa.XidImpl;
import org.seasar.framework.exception.SIllegalStateException;
import org.seasar.framework.exception.SRollbackException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.SLinkedList;

public final class TransactionImpl
implements Transaction {
    private static final int VOTE_READONLY = 0;
    private static final int VOTE_COMMIT = 1;
    private static final int VOTE_ROLLBACK = 2;
    private static Logger logger_ = Logger.getLogger((Class)TransactionImpl.class);
    private Xid xid_;
    private int status_ = 6;
    private List xaResourceWrappers_ = new ArrayList();
    private List synchronizations_ = new ArrayList();
    private List interposedSynchronizations_ = new ArrayList();
    private Map resourceMap_ = new HashMap();
    private boolean suspended_ = false;
    private int branchId_ = 0;

    public void begin() {
        this.status_ = 0;
        this.init();
        if (logger_.isDebugEnabled()) {
            logger_.log("DSSR0003", null);
        }
    }

    public void suspend() throws XAException {
        this.assertNotSuspended();
        this.assertActive();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            xarw.end(0x2000000);
        }
        this.suspended_ = true;
    }

    private void assertNotSuspended() throws IllegalStateException {
        if (this.suspended_) {
            throw new SIllegalStateException("ESSR0314", null);
        }
    }

    private void assertActive() throws IllegalStateException {
        switch (this.status_) {
            case 0: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    private void throwIllegalStateException() throws IllegalStateException {
        switch (this.status_) {
            case 7: {
                throw new SIllegalStateException("ESSR0304", null);
            }
            case 2: {
                throw new SIllegalStateException("ESSR0305", null);
            }
            case 8: {
                throw new SIllegalStateException("ESSR0306", null);
            }
            case 3: {
                throw new SIllegalStateException("ESSR0307", null);
            }
            case 1: {
                throw new SIllegalStateException("ESSR0308", null);
            }
            case 9: {
                throw new SIllegalStateException("ESSR0309", null);
            }
            case 4: {
                throw new SIllegalStateException("ESSR0310", null);
            }
            case 6: {
                throw new SIllegalStateException("ESSR0311", null);
            }
            case 5: {
                throw new SIllegalStateException("ESSR0312", null);
            }
        }
        throw new SIllegalStateException("ESSR0032", new Object[]{String.valueOf(this.status_)});
    }

    private int getXAResourceWrapperSize() {
        return this.xaResourceWrappers_.size();
    }

    private XAResourceWrapper getXAResourceWrapper(int index) {
        return (XAResourceWrapper)this.xaResourceWrappers_.get(index);
    }

    public void resume() throws XAException {
        this.assertSuspended();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            xarw.start(0x8000000);
        }
        this.suspended_ = false;
    }

    private void assertSuspended() throws IllegalStateException {
        if (!this.suspended_) {
            throw new SIllegalStateException("ESSR0315", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            boolean committed;
            this.assertNotSuspended();
            this.assertActive();
            this.beforeCompletion();
            this.endResources(0x4000000);
            if (this.status_ == 0) {
                if (this.getXAResourceWrapperSize() == 0) {
                    this.status_ = 3;
                } else if (this.getXAResourceWrapperSize() == 1) {
                    this.commitOnePhase();
                } else {
                    switch (this.prepareResources()) {
                        case 0: {
                            this.status_ = 3;
                            break;
                        }
                        case 1: {
                            this.commitTwoPhase();
                            break;
                        }
                        case 2: {
                            this.rollbackForVoteOK();
                        }
                    }
                }
            }
            boolean bl = committed = this.status_ == 3;
            if (committed && logger_.isDebugEnabled()) {
                logger_.log("DSSR0004", null);
            }
            this.afterCompletion();
            if (!committed) {
                throw new SRollbackException("ESSR0303", new Object[]{this.toString()});
            }
        }
        finally {
            this.destroy();
        }
    }

    private void beforeCompletion() {
        int i;
        for (i = 0; i < this.getSynchronizationSize(); ++i) {
            this.beforeCompletion(this.getSynchronization(i));
        }
        for (i = 0; i < this.getInterposedSynchronizationSize(); ++i) {
            this.beforeCompletion(this.getInterposedSynchronization(i));
        }
    }

    private void beforeCompletion(Synchronization sync) {
        try {
            sync.beforeCompletion();
        }
        catch (RuntimeException ex) {
            this.status_ = 1;
            this.endResources(0x20000000);
            this.rollbackResources();
            this.afterCompletion();
            throw ex;
        }
    }

    private void endResources(int flag) {
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                xarw.end(flag);
                continue;
            }
            catch (Throwable t) {
                logger_.log(t);
                this.status_ = 1;
            }
        }
    }

    private void commitOnePhase() {
        this.status_ = 8;
        XAResourceWrapper xari = this.getXAResourceWrapper(0);
        try {
            xari.commit(true);
            this.status_ = 3;
        }
        catch (XAException ex) {
            logger_.log((Throwable)ex);
            this.status_ = 5;
        }
    }

    private int prepareResources() {
        XAResourceWrapper xarw;
        int i;
        this.status_ = 7;
        int vote = 0;
        SLinkedList xarwList = new SLinkedList();
        for (i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            xarw = this.getXAResourceWrapper(i);
            if (!xarw.isCommitTarget()) continue;
            xarwList.addFirst((Object)xarw);
        }
        for (i = 0; i < xarwList.size(); ++i) {
            xarw = (XAResourceWrapper)xarwList.get(i);
            try {
                if (i == xarwList.size() - 1) {
                    xarw.commit(true);
                    xarw.setVoteOk(false);
                    vote = 1;
                    continue;
                }
                if (xarw.prepare() == 0) {
                    vote = 1;
                    continue;
                }
                xarw.setVoteOk(false);
                continue;
            }
            catch (XAException ex) {
                xarw.setVoteOk(false);
                this.status_ = 1;
                return 2;
            }
        }
        if (this.status_ == 7) {
            this.status_ = 2;
        }
        return vote;
    }

    private void commitTwoPhase() {
        this.status_ = 8;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xarw.isCommitTarget() || !xarw.isVoteOk()) continue;
            try {
                xarw.commit(false);
                continue;
            }
            catch (Throwable t) {
                logger_.log(t);
                this.status_ = 5;
            }
        }
        if (this.status_ == 8) {
            this.status_ = 3;
        }
    }

    private void rollbackForVoteOK() {
        this.status_ = 9;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xarw.isVoteOk()) continue;
            try {
                xarw.rollback();
                continue;
            }
            catch (Throwable t) {
                logger_.log(t);
                this.status_ = 5;
            }
        }
        if (this.status_ == 9) {
            this.status_ = 4;
        }
    }

    private void afterCompletion() {
        int i;
        for (i = 0; i < this.getInterposedSynchronizationSize(); ++i) {
            this.afterCompletion(this.getInterposedSynchronization(i));
        }
        for (i = 0; i < this.getSynchronizationSize(); ++i) {
            this.afterCompletion(this.getSynchronization(i));
        }
    }

    private void afterCompletion(Synchronization sync) {
        try {
            sync.afterCompletion(this.status_);
        }
        catch (Throwable t) {
            logger_.log(t);
        }
    }

    private int getSynchronizationSize() {
        return this.synchronizations_.size();
    }

    private Synchronization getSynchronization(int index) {
        return (Synchronization)this.synchronizations_.get(index);
    }

    private int getInterposedSynchronizationSize() {
        return this.interposedSynchronizations_.size();
    }

    private Synchronization getInterposedSynchronization(int index) {
        return (Synchronization)this.interposedSynchronizations_.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.assertNotSuspended();
            this.assertActiveOrMarkedRollback();
            this.endResources(0x20000000);
            this.rollbackResources();
            if (logger_.isDebugEnabled()) {
                logger_.log("DSSR0005", null);
            }
            this.afterCompletion();
        }
        finally {
            this.destroy();
        }
    }

    private void assertActiveOrMarkedRollback() throws IllegalStateException {
        switch (this.status_) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    private void rollbackResources() {
        this.status_ = 9;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            try {
                if (!xarw.isCommitTarget()) continue;
                xarw.rollback();
                continue;
            }
            catch (Throwable t) {
                logger_.log(t);
                this.status_ = 5;
            }
        }
        if (this.status_ == 9) {
            this.status_ = 4;
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActiveOrPreparingOrPrepared();
        this.status_ = 1;
    }

    private void assertActiveOrPreparingOrPrepared() throws IllegalStateException {
        switch (this.status_) {
            case 0: 
            case 2: 
            case 7: {
                break;
            }
            default: {
                this.throwIllegalStateException();
            }
        }
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        boolean commitTarget;
        boolean oracled = xaResource.getClass().getName().startsWith("oracle");
        this.assertNotSuspended();
        this.assertActive();
        Xid xid = null;
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (xaResource.equals(xarw.getXAResource())) {
                return false;
            }
            if (oracled) continue;
            try {
                if (!xaResource.isSameRM(xarw.getXAResource())) continue;
                xid = xarw.getXid();
                break;
            }
            catch (XAException ex) {
                throw new IllegalStateException(ex.toString());
            }
        }
        int flag = xid == null ? 0 : 0x200000;
        boolean bl = commitTarget = xid == null;
        if (xid == null) {
            xid = this.createXidBranch();
        }
        try {
            xaResource.start(xid, flag);
            this.xaResourceWrappers_.add(new XAResourceWrapper(xaResource, xid, commitTarget));
            return true;
        }
        catch (XAException ex) {
            IllegalStateException ise = new IllegalStateException(ex.toString());
            ise.initCause(ex);
            throw ise;
        }
    }

    private Xid createXidBranch() {
        return new XidImpl(this.xid_, ++this.branchId_);
    }

    public boolean delistResource(XAResource xaResource, int flag) throws IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActiveOrMarkedRollback();
        for (int i = 0; i < this.getXAResourceWrapperSize(); ++i) {
            XAResourceWrapper xarw = this.getXAResourceWrapper(i);
            if (!xaResource.equals(xarw.getXAResource())) continue;
            try {
                xarw.end(flag);
                return true;
            }
            catch (XAException ex) {
                logger_.log((Throwable)ex);
                this.status_ = 1;
                return false;
            }
        }
        throw new SIllegalStateException("ESSR0313", null);
    }

    public int getStatus() {
        return this.status_;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.assertNotSuspended();
        this.assertActive();
        this.synchronizations_.add(sync);
    }

    public void registerInterposedSynchronization(Synchronization sync) throws IllegalStateException {
        this.assertNotSuspended();
        this.assertActive();
        this.interposedSynchronizations_.add(sync);
    }

    public void putResource(Object key, Object value) throws IllegalStateException {
        this.assertNotSuspended();
        this.assertActive();
        this.resourceMap_.put(key, value);
    }

    public Object getResource(Object key) throws IllegalStateException {
        this.assertNotSuspended();
        this.assertActive();
        return this.resourceMap_.get(key);
    }

    public Xid getXid() {
        return this.xid_;
    }

    public boolean isSuspended() {
        return this.suspended_;
    }

    private void init() {
        this.xid_ = new XidImpl();
    }

    private void destroy() {
        this.status_ = 6;
        this.xaResourceWrappers_.clear();
        this.synchronizations_.clear();
        this.interposedSynchronizations_.clear();
        this.resourceMap_.clear();
        this.suspended_ = false;
    }

    public String toString() {
        return this.xid_.toString();
    }
}

