/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jta;

import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.seasar.extension.jta.TransactionImpl;
import org.seasar.framework.util.TransactionManagerUtil;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    private TransactionManager tm;

    public void setTransactionManager(TransactionManager tm) {
        this.tm = tm;
    }

    public void putResource(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.assertActive();
        this.getTransaction().putResource(key, value);
    }

    public Object getResource(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.assertActive();
        return this.getTransaction().getResource(key);
    }

    public void setRollbackOnly() {
        this.assertActive();
        TransactionManagerUtil.setRollbackOnly((TransactionManager)this.tm);
    }

    public boolean getRollbackOnly() {
        this.assertActive();
        switch (this.getTransactionStatus()) {
            case 1: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public Object getTransactionKey() {
        if (!this.isActive()) {
            return null;
        }
        return this.getTransaction();
    }

    public int getTransactionStatus() {
        return TransactionManagerUtil.getStatus((TransactionManager)this.tm);
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        this.assertActive();
        this.getTransaction().registerInterposedSynchronization(sync);
    }

    protected TransactionImpl getTransaction() {
        return (TransactionImpl)TransactionManagerUtil.getTransaction((TransactionManager)this.tm);
    }

    protected void assertActive() {
        if (!this.isActive()) {
            throw new IllegalStateException("ESSR0311");
        }
    }

    protected boolean isActive() {
        return TransactionManagerUtil.isActive((TransactionManager)this.tm);
    }
}

