/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

public class FactoryFinderUtil {
    private static final List VALID_FACTORY_NAMES = new ArrayList();
    private static final Map ABSTRACT_FACTORY_CLASSES = new HashMap();

    private FactoryFinderUtil() {
    }

    public static void checkValidFactoryNames(String factoryName) {
        if (!VALID_FACTORY_NAMES.contains(factoryName)) {
            throw new IllegalArgumentException("Factory name can not be identified.");
        }
    }

    public static ClassLoader getClassLoader() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = FactoryFinderUtil.class.getClassLoader();
        }
        if (classLoader == null) {
            throw new FacesException();
        }
        return classLoader;
    }

    public static Class getAbstractFactoryClass(String factoryName) {
        return (Class)ABSTRACT_FACTORY_CLASSES.get(factoryName);
    }

    public static Object createFactoryInstance(String factoryName, List classNames) {
        ClassLoader loader = FactoryFinderUtil.getClassLoader();
        Class abstractFactoryClass = FactoryFinderUtil.getAbstractFactoryClass(factoryName);
        Object current = null;
        Class<?> implClass = null;
        Iterator classNamesIterator = classNames.iterator();
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            try {
                implClass = loader.loadClass(implClassName);
            }
            catch (ClassNotFoundException e) {
                throw new FacesException(e);
            }
            if (!abstractFactoryClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + abstractFactoryClass.getName());
            }
            current = FactoryFinderUtil.getCurrentFactoryInstance(implClass, abstractFactoryClass, current);
        }
        return current;
    }

    public static Object getCurrentFactoryInstance(Class implClass, Class abstractFactoryClass, Object current) {
        if (implClass == null) {
            if (current == null) {
                throw new IllegalArgumentException();
            }
            return current;
        }
        Constructor constructor = FactoryFinderUtil.getConstructor(implClass, new Class[]{abstractFactoryClass});
        current = constructor != null ? FactoryFinderUtil.newInstanceByConstructor(constructor, new Object[]{current}) : FactoryFinderUtil.newInstance(implClass);
        return current;
    }

    public static Constructor getConstructor(Class clazz, Class[] argTypes) {
        if (clazz == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Object newInstance(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new FacesException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e);
        }
    }

    public static Object newInstanceByConstructor(Constructor constructor, Object[] args) {
        if (constructor == null || args == null) {
            throw new IllegalArgumentException();
        }
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new FacesException(e);
        }
        catch (InstantiationException e) {
            throw new FacesException(e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(e);
        }
        catch (InvocationTargetException e) {
            throw new FacesException(e);
        }
    }

    public static boolean isAlreadySetFactory(Map factoryMap, String factoryName) {
        return factoryMap != null && factoryMap.containsKey(factoryName);
    }

    static {
        VALID_FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        VALID_FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        VALID_FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        VALID_FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        ABSTRACT_FACTORY_CLASSES.put("javax.faces.application.ApplicationFactory", ApplicationFactory.class);
        ABSTRACT_FACTORY_CLASSES.put("javax.faces.context.FacesContextFactory", FacesContextFactory.class);
        ABSTRACT_FACTORY_CLASSES.put("javax.faces.lifecycle.LifecycleFactory", LifecycleFactory.class);
        ABSTRACT_FACTORY_CLASSES.put("javax.faces.render.RenderKitFactory", RenderKitFactory.class);
    }
}

