/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.MessageResourceBundleChainFactory;
import javax.faces.internal.NamingConventionUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.message.MessageResourceBundle;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ViewHandlerUtil;

public class LabelUtil {
    public static String getLabelValue(String defaultKey) {
        String viewId;
        if (defaultKey == null) {
            return null;
        }
        int index = defaultKey.lastIndexOf(45);
        if (index > 0) {
            defaultKey = defaultKey.substring(0, index);
        }
        if ((viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId()) == null) {
            return null;
        }
        NamingConvention nc = (NamingConvention)DIContainerUtil.getComponent(NamingConvention.class);
        if (!nc.isValidViewRootPath(viewId)) {
            return null;
        }
        String pageName = nc.fromPathToPageName(viewId);
        String key = LabelUtil.getKey(nc, pageName, defaultKey);
        String propertiesName = LabelUtil.getPropertiesName(nc, pageName);
        String defaultPropertiesName = LabelUtil.getDefaultApplicationPropertiesName(nc, pageName);
        return LabelUtil.getLabelValue(key, propertiesName, defaultKey, defaultPropertiesName);
    }

    private static String getKey(NamingConvention nc, String pageName, String defaultKey) {
        String labelKeySuffix = LabelUtil.getLabelKeySuffix(nc, pageName);
        return new String(new StringBuffer(labelKeySuffix.length() + defaultKey.length() + 1).append(labelKeySuffix).append(".").append(defaultKey));
    }

    public static String getLabelValue(String key, String propertiesName, String defaultKey, String defaultPropertiesName) {
        MessageResourceBundle bundle;
        Locale locale = ViewHandlerUtil.getLocale();
        String value = null;
        if (propertiesName != null) {
            bundle = MessageResourceBundleChainFactory.createChain(propertiesName, locale);
            String string = value = bundle != null ? bundle.get(key) : null;
            if (value == null && bundle != null) {
                value = bundle.get(defaultKey);
            }
        }
        if (value == null && defaultPropertiesName != null) {
            bundle = MessageResourceBundleChainFactory.createChain(defaultPropertiesName, locale);
            value = bundle != null ? bundle.get(defaultKey) : null;
        }
        return value;
    }

    public static String getPropertiesName(NamingConvention nc, String pageName) {
        String packageName = NamingConventionUtil.getPackageName(nc, pageName);
        return packageName != null ? new String(new StringBuffer(packageName.length() + 5).append(packageName).append(".").append("label")) : null;
    }

    public static String getLabelKeySuffix(NamingConvention nc, String pageName) {
        int lastIndex;
        String defaultSuffix;
        String path = nc.fromPageNameToPath(pageName);
        if (path.endsWith(defaultSuffix = FacesConfigOptions.getDefaultSuffix())) {
            path = path.substring(0, path.lastIndexOf(defaultSuffix));
        }
        if ((lastIndex = path.lastIndexOf(47)) > 0) {
            path = path.substring(lastIndex + 1);
        }
        return path;
    }

    public static String getDefaultApplicationPropertiesName(NamingConvention nc, String pageName) {
        String subAppRoot = nc.getSubApplicationRootPackageName();
        String defaultPropertiesName = null;
        String packageName = NamingConventionUtil.getPackageName(nc, pageName);
        if (packageName == null) {
            return null;
        }
        if (packageName.lastIndexOf(subAppRoot) > 0) {
            int len = packageName.lastIndexOf(subAppRoot) + subAppRoot.length();
            String s = packageName.substring(0, len);
            defaultPropertiesName = new String(new StringBuffer(s.length() + 5).append(s).append(".").append("label"));
        }
        return defaultPropertiesName;
    }
}

