/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.RenderPreparable;
import javax.faces.internal.UIComponentUtil;
import javax.faces.render.Renderer;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.render.RenderPreparableRenderer;

public abstract class RenderPreparableUtil {
    protected RenderPreparableUtil() {
    }

    public static void encodePrepareForRenderer(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        Renderer renderer = UIComponentUtil.getRenderer(context, component);
        if (renderer != null && renderer instanceof RenderPreparableRenderer) {
            ((RenderPreparableRenderer)((Object)renderer)).encodePrepare(context, component);
        }
    }

    public static void encodePrepareForComponent(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        String componentName = component.getClass().getName();
        if (!componentName.endsWith("TCondition") && !component.isRendered()) {
            return;
        }
        if (component instanceof RenderPreparable) {
            ((RenderPreparable)((Object)component)).encodePrepare(context);
        }
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                RenderPreparableUtil.encodePrepareForComponent(context, child);
            }
        }
    }
}

