/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.internal.LabelUtil;
import javax.faces.internal.RenderKitUtil;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.teeda.core.exception.TagNotFoundRuntimeException;

public class UIComponentUtil {
    public static boolean isDisabled(UIComponent component) {
        return UIComponentUtil.getPrimitiveBooleanAttribute(component, "disabled");
    }

    public static String getStringAttribute(UIComponent component, String name) {
        return (String)component.getAttributes().get(name);
    }

    public static boolean getPrimitiveBooleanAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public static int getPrimitiveIntAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    public static String getLabel(UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label != null) {
            return label;
        }
        label = LabelUtil.getLabelValue(component.getId());
        if (label != null) {
            return label;
        }
        String title = (String)component.getAttributes().get("title");
        if (title != null) {
            return title;
        }
        return component.getId();
    }

    public static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        FacesMessage facesMessage;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                input.setValid(false);
                facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                context.addMessage(input.getClientId(context), facesMessage);
            }
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    facesMessage = ((ValidatorException)cause).getFacesMessage();
                    if (facesMessage != null) {
                        context.addMessage(input.getClientId(context), facesMessage);
                    }
                }
                throw e;
            }
        }
    }

    public static UIForm findParentForm(UIComponent component) {
        UIComponent parent = UIComponentUtil.findParentOrNull(component, UIForm.class);
        if (parent == null) {
            throw new TagNotFoundRuntimeException("form");
        }
        return (UIForm)parent;
    }

    public static UIComponent findParent(UIComponent component, Class parentClass) {
        UIComponent parent = UIComponentUtil.findParentOrNull(component, parentClass);
        if (parent != null) {
            return parent;
        }
        throw new IllegalArgumentException("parent element not found [" + parentClass.getName() + "]");
    }

    private static UIComponent findParentOrNull(UIComponent component, Class parentClass) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isInstance(parent)) continue;
            return parent;
        }
        return null;
    }

    public static UIComponent findDescendant(UIComponent component, Class clazz) {
        List children = component.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (clazz.isInstance(child)) {
                return child;
            }
            UIComponent descendant = UIComponentUtil.findDescendant(child, clazz);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    public static Renderer getRenderer(FacesContext context, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            return null;
        }
        RenderKit renderKit = RenderKitUtil.getRenderKit(context);
        return renderKit.getRenderer(component.getFamily(), rendererType);
    }
}

