/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;

public class LengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.Length";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private int maximum = -1;
    private int minimum = -1;
    private boolean transientValue = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        this.maximum = maximum;
    }

    public LengthValidator(int maximum, int minimum) {
        this.maximum = maximum;
        this.minimum = minimum;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LengthValidator)) {
            return false;
        }
        LengthValidator v = (LengthValidator)obj;
        return this.maximum == v.maximum && this.minimum == v.minimum;
    }

    public int hashCode() {
        return this.maximum * this.minimum * 17;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        int length = this.getConvertedValueLength(value);
        if (this.minimum > -1 && length < this.minimum) {
            Object[] args = new Object[]{new Integer(this.minimum), UIComponentUtil.getLabel(component)};
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMinimumMessageId(), args), this.getMinimumMessageId(), args);
        }
        if (this.maximum > -1 && length > this.maximum) {
            Object[] args = new Object[]{new Integer(this.maximum), UIComponentUtil.getLabel(component)};
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMaximumMessageId(), args), this.getMaximumMessageId(), args);
        }
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{new Integer(this.maximum), new Integer(this.minimum)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Integer)values[0];
        this.minimum = (Integer)values[1];
    }

    protected int getConvertedValueLength(Object value) {
        int length = 0;
        length = value instanceof String ? ((String)value).length() : value.toString().length();
        return length;
    }

    protected String getMinimumMessageId() {
        return MINIMUM_MESSAGE_ID;
    }

    protected String getMaximumMessageId() {
        return MAXIMUM_MESSAGE_ID;
    }
}

