/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import org.seasar.teeda.core.application.TeedaStateManager;
import org.seasar.teeda.core.application.TreeStructure;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.ResponseStateManagerUtil;

public class TeedaStateManagerImpl
extends TeedaStateManager
implements Serializable {
    static final long serialVersionUID = 0L;
    private final Map serializedViews = new HashMap();

    public synchronized UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        TeedaStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        UIViewRoot viewRoot = this.restoreTreeStructure(context, viewId, renderKitId);
        if (viewRoot != null) {
            viewRoot.setViewId(viewId);
            this.restoreComponentState(context, viewRoot, renderKitId);
            if (PortletUtil.isPortlet(context)) {
                this.removeSerializedView(viewId);
            }
        }
        return viewRoot;
    }

    public synchronized StateManager.SerializedView saveSerializedView(FacesContext context) throws IllegalStateException {
        if (this.isSavingStateInClient(context)) {
            return this.createSerializedView(context);
        }
        this.saveViewToServer(context, context.getViewRoot());
        return null;
    }

    protected synchronized void saveSerializedViewToServer(FacesContext context, String viewId, StateManager.SerializedView serializedView) {
        if (!this.hasSerializedViewInServer(viewId)) {
            this.saveSerializedViewToServer(viewId, serializedView);
        }
    }

    public synchronized void removeSerializedView(String viewId) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && PortletUtil.isPortlet(context) && !this.isSavingStateInClient(context)) {
            context.getExternalContext().getSessionMap().remove(SERIALIZED_VIEW_ATTR + "-" + viewId);
            return;
        }
        this.serializedViews.remove(viewId);
    }

    public synchronized void writeState(FacesContext context, StateManager.SerializedView serializedView) throws IOException {
        if (this.isSavingStateInClient(context)) {
            UIViewRoot viewRoot = context.getViewRoot();
            ResponseStateManager responseStateManager = this.getResponseStateManager(context, viewRoot.getRenderKitId());
            responseStateManager.writeState(context, serializedView);
        }
    }

    public Object getComponentStateToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    public Object getTreeStructureToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        return this.getTreeStructureManager().buildTreeStructure(viewRoot);
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        TeedaStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        if (viewRoot.getRenderKitId() == null) {
            viewRoot.setRenderKitId(renderKitId);
        }
        if (this.isSavingStateInClient(context)) {
            this.restoreComponentStateFromClient(context, viewRoot, renderKitId);
        } else {
            this.restoreComponentStateFromServer(context, viewRoot);
        }
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        TeedaStateManagerImpl.assertRenderKitIdNotNull(renderKitId);
        if (this.isSavingStateInClient(context)) {
            return this.restoreTreeStructureFromClient(context, viewId, renderKitId);
        }
        return this.restoreTreeStructureFromServer(context, viewId);
    }

    protected void restoreComponentStateFromClient(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        ResponseStateManager responseStateManager = this.getResponseStateManager(context, renderKitId);
        Object state = responseStateManager.getComponentStateToRestore(context);
        viewRoot.processRestoreState(context, state);
    }

    protected void restoreComponentStateFromServer(FacesContext context, UIViewRoot viewRoot) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromServer(viewRoot.getViewId());
        if (serializedView == null) {
            return;
        }
        Object state = serializedView.getState();
        if (state == null) {
            return;
        }
        viewRoot.processRestoreState(context, state);
    }

    protected UIViewRoot restoreTreeStructureFromClient(FacesContext context, String viewId, String renderKitId) {
        ResponseStateManager responseStateManager = this.getResponseStateManager(context, renderKitId);
        TreeStructure struct = (TreeStructure)responseStateManager.getTreeStructureToRestore(context, viewId);
        if (struct == null) {
            return null;
        }
        return (UIViewRoot)this.getTreeStructureManager().restoreTreeStructure(struct);
    }

    protected UIViewRoot restoreTreeStructureFromServer(FacesContext context, String viewId) {
        StateManager.SerializedView serializedView = this.getSerializedViewFromServer(viewId);
        if (serializedView == null) {
            return null;
        }
        TreeStructure struct = (TreeStructure)serializedView.getStructure();
        return (UIViewRoot)this.getTreeStructureManager().restoreTreeStructure(struct);
    }

    private static void assertRenderKitIdNotNull(String renderKitId) {
        if (renderKitId == null) {
            throw new IllegalArgumentException();
        }
    }

    protected StateManager.SerializedView getSerializedViewFromServer(String viewId) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && PortletUtil.isPortlet(context)) {
            return (StateManager.SerializedView)context.getExternalContext().getSessionMap().get(SERIALIZED_VIEW_ATTR + "-" + viewId);
        }
        return (StateManager.SerializedView)this.serializedViews.get(viewId);
    }

    protected boolean hasSerializedViewInServer(String viewId) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && PortletUtil.isPortlet(context)) {
            return context.getExternalContext().getSessionMap().containsKey(SERIALIZED_VIEW_ATTR + "-" + viewId);
        }
        return this.serializedViews.containsKey(viewId);
    }

    protected void saveSerializedViewToServer(String viewId, StateManager.SerializedView serializedView) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && PortletUtil.isPortlet(context)) {
            context.getExternalContext().getSessionMap().put(SERIALIZED_VIEW_ATTR + "-" + viewId, serializedView);
            return;
        }
        this.serializedViews.put(viewId, serializedView);
    }

    private ResponseStateManager getResponseStateManager(FacesContext context, String renderKitId) {
        return ResponseStateManagerUtil.getResponseStateManager(context, renderKitId);
    }

    public boolean hasSerializedView(FacesContext context, String viewId) {
        if (this.isSavingStateInClient(context)) {
            return false;
        }
        return this.hasSerializedViewInServer(viewId);
    }
}

