/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.teeda.core.lifecycle.AbstractPhase;
import org.seasar.teeda.core.lifecycle.Phase;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.PostbackUtil;

public class LifecycleImpl
extends Lifecycle {
    private static final String EXECUTED_ATTR = LifecycleImpl.class.getName() + ".EXECUTED";
    private PhaseListener[] phaseListeners = new PhaseListener[0];
    private Phase restoreViewPhase;
    private AbstractPhase applyRequestValuesPhase;
    private Phase invokeApplicationPhase;
    private Phase renderResponsePhase;
    private Phase processValidationPhase;
    private Phase updateModelValuesPhase;
    private ErrorPageManager errorPageManager;

    public void execute(FacesContext context) throws FacesException {
        ExternalContext extContext = context.getExternalContext();
        Map requestMap = extContext.getRequestMap();
        requestMap.put("facesContext", context);
        try {
            this.restoreViewPhase.execute(context);
            boolean postback = PostbackUtil.isPostback(requestMap);
            if (!postback || this.isFinished(context)) {
                return;
            }
            if (requestMap.containsKey(EXECUTED_ATTR)) {
                context.renderResponse();
                return;
            }
            requestMap.put(EXECUTED_ATTR, EXECUTED_ATTR);
            this.applyRequestValuesPhase.execute(context);
            if (this.isFinished(context)) {
                this.applyRequestValuesPhase.initializeChildren(context, context.getViewRoot());
                return;
            }
            if (postback || this.hasEvent(context)) {
                this.processValidationPhase.execute(context);
                if (this.isFinished(context)) {
                    return;
                }
            }
            this.updateModelValuesPhase.execute(context);
            if (this.isFinished(context)) {
                return;
            }
            this.invokeApplicationPhase.execute(context);
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
        catch (Exception e) {
            this.handleException(context, e);
        }
    }

    protected void handleException(FacesContext context, Exception e) {
        ErrorPageManager manager = this.getErrorPageManager();
        ExternalContext externalContext = context.getExternalContext();
        try {
            if (!manager.handleException(e, context, externalContext)) {
                throw (RuntimeException)e;
            }
            context.responseComplete();
        }
        catch (IOException ioe) {
            throw new FacesException(ioe.getMessage(), ioe);
        }
    }

    public void render(FacesContext context) throws FacesException {
        if (context.getResponseComplete()) {
            return;
        }
        try {
            this.renderResponsePhase.execute(context);
        }
        catch (FacesException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(context, e);
        }
    }

    protected boolean isFinished(FacesContext context) throws FacesException {
        return context.getResponseComplete() || context.getRenderResponse();
    }

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.add((Object[])this.phaseListeners, (Object)listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.remove((Object[])this.phaseListeners, (Object)listener);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.phaseListeners;
    }

    protected boolean hasEvent(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        return viewRoot.getEventSize() > 0;
    }

    public void setRestoreViewPhase(Phase restoreViewPhase) {
        this.restoreViewPhase = restoreViewPhase;
    }

    public void setApplyRequestValuesPhase(AbstractPhase applyRequestValuesPhase) {
        this.applyRequestValuesPhase = applyRequestValuesPhase;
    }

    public void setInvokeApplicationPhase(Phase invokeApplicationPhase) {
        this.invokeApplicationPhase = invokeApplicationPhase;
    }

    public void setRenderResponsePhase(Phase renderPhase) {
        this.renderResponsePhase = renderPhase;
    }

    public void setProcessValidationsPhase(Phase processValidationPhase) {
        this.processValidationPhase = processValidationPhase;
    }

    public void setUpdateModelValuesPhase(Phase updateModelValuesPhase) {
        this.updateModelValuesPhase = updateModelValuesPhase;
    }

    public AbstractPhase getApplyRequestValuesPhase() {
        return this.applyRequestValuesPhase;
    }

    public Phase getInvokeApplicationPhase() {
        return this.invokeApplicationPhase;
    }

    public Phase getProcessValidationPhase() {
        return this.processValidationPhase;
    }

    public Phase getRenderResponsePhase() {
        return this.renderResponsePhase;
    }

    public Phase getRestoreViewPhase() {
        return this.restoreViewPhase;
    }

    public Phase getUpdateModelValuesPhase() {
        return this.updateModelValuesPhase;
    }

    public ErrorPageManager getErrorPageManager() {
        return this.errorPageManager;
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this.errorPageManager = errorPageManager;
    }
}

