/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.portlet;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.WebAppUtil;
import javax.faces.internal.scope.RedirectScope;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletException;
import org.seasar.framework.log.Logger;

public class FacesPortlet
extends GenericPortlet {
    private static final Logger logger = Logger.getLogger((Class)FacesPortlet.class);
    public static final String PORTLET_CONFIG = "javax.portlet.PortletConfig";
    public static final String VIEW_ID = FacesPortlet.class.getName() + ".VIEW_ID";
    public static final String DEFAULT_PAGE = FacesPortlet.class.getName() + ".DEFAULT_PAGE";
    public static final String DEFAULT_VIEW_PAGE = "view-page";
    public static final String DEFAULT_EDIT_PAGE = "edit-page";
    public static final String DEFAULT_HELP_PAGE = "help-page";
    public static final String FACES_PORTLET_STATE_PREFIX = FacesPortlet.class.getName() + ".FACES_PORTLET_STATE" + "-";
    public static final String PREVIOUS_PORTLET_MODE = FacesPortlet.class.getName() + ".PREVIOUS_PORTLET_MODE";
    public static final String CURRENT_PORTLET_MODE = FacesPortlet.class.getName() + ".CURRENT_PORTLET_MODE";
    public static final String EXCLUDED_ATTRIBUTE_LIST = FacesPortlet.class.getName() + ".EXCLUDED_ATTRIBUTE_LIST";
    public static final String REDEPLOYED_PORTLET = FacesPortlet.class.getName() + ".REDEPLOYED_PORTLET";
    public static final String RENDER_PARAMETER = FacesPortlet.class.getName() + ".RENDER_PARAMETER";
    protected FacesContextFactory facesContextFactory;
    protected Lifecycle lifecycle;
    private String defaultViewPage = null;
    private String defaultEditPage = null;
    private String defaultHelpPage = null;

    public void init() throws PortletException {
        super.init();
        this.defaultViewPage = this.getPortletConfig().getInitParameter(DEFAULT_VIEW_PAGE);
        this.defaultEditPage = this.getPortletConfig().getInitParameter(DEFAULT_EDIT_PAGE);
        this.defaultHelpPage = this.getPortletConfig().getInitParameter(DEFAULT_HELP_PAGE);
        if (null == this.defaultViewPage) {
            throw new PortletException("Portlet " + this.getPortletConfig().getPortletName() + " is incorrectly configured. No default View page is defined.");
        }
        if (null == this.defaultEditPage) {
            this.defaultEditPage = this.defaultViewPage;
        }
        if (null == this.defaultHelpPage) {
            this.defaultHelpPage = this.defaultViewPage;
        }
        try {
            this.facesContextFactory = (FacesContextFactory)WebAppUtil.getFactory("javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)WebAppUtil.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = this.getLifecycleId(this.getPortletContext());
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (ServletException e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected String getLifecycleId(PortletContext portletContext) {
        String lifecycleId = portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null) {
            lifecycleId = "DEFAULT";
        }
        return lifecycleId;
    }

    public void destroy() {
        super.destroy();
        FactoryFinder.releaseFactories();
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.defaultViewPage = null;
        this.defaultEditPage = null;
        this.defaultHelpPage = null;
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultEditPage);
        this.renderFaces(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultHelpPage);
        this.renderFaces(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.setContentType(request, response);
        this.setDefaultPage((PortletRequest)request, this.defaultViewPage);
        this.renderFaces(request, response);
    }

    protected void setContentType(RenderRequest request, RenderResponse response) {
        if (response.getContentType() == null) {
            String portalPreferredContentType = request.getResponseContentType();
            if (portalPreferredContentType != null) {
                response.setContentType(portalPreferredContentType);
            } else {
                response.setContentType("text/html");
            }
        }
    }

    protected void setDefaultPage(PortletRequest request, String page) {
        if (request.getAttribute(DEFAULT_PAGE) == null) {
            request.setAttribute(DEFAULT_PAGE, (Object)page);
        }
    }

    protected void storePortletConfig(PortletRequest request) {
        request.setAttribute(PORTLET_CONFIG, (Object)this.getPortletConfig());
    }

    protected void setCurrentPortletMode(PortletRequest request) {
        request.setAttribute(CURRENT_PORTLET_MODE, (Object)request.getPortletMode().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFaces(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"called renderFaces..");
        }
        this.createExcludedAttributeList((PortletRequest)request);
        this.storePortletConfig((PortletRequest)request);
        this.setCurrentPortletMode((PortletRequest)request);
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
        request.setAttribute("facesContext", (Object)facesContext);
        this.restoreFacesState(facesContext);
        String redirectPath = null;
        try {
            this.lifecycle.render(facesContext);
            redirectPath = RedirectScope.getRedirectingPath(facesContext);
            if (redirectPath != null) {
                RedirectScope.removeContext(facesContext);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        finally {
            facesContext.release();
            request.getPortletSession().setAttribute(PREVIOUS_PORTLET_MODE, (Object)request.getPortletMode().toString());
            request.getPortletSession().setAttribute(REDEPLOYED_PORTLET, (Object)Boolean.FALSE);
        }
        if (redirectPath != null) {
            this.redirectRenderFaces(request, response, redirectPath);
        }
    }

    protected void redirectRenderFaces(RenderRequest request, RenderResponse response, String viewId) throws PortletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("called redirectRenderFaces.. viewId is " + viewId));
        }
        List excludedNameList = (List)request.getAttribute(EXCLUDED_ATTRIBUTE_LIST);
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (excludedNameList.contains(key)) continue;
            request.removeAttribute(key);
        }
        request.getPortletSession().removeAttribute(PREVIOUS_PORTLET_MODE);
        request.setAttribute(DEFAULT_PAGE, (Object)viewId);
        this.renderFaces(request, response);
    }

    protected void restoreFacesState(FacesContext facesContext) {
        Map sessionMap = facesContext.getExternalContext().getSessionMap();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String currentPortletMode = (String)requestMap.get(CURRENT_PORTLET_MODE);
        String previousPortletMode = (String)sessionMap.get(PREVIOUS_PORTLET_MODE);
        FacesPortletState state = null;
        if (previousPortletMode != null && previousPortletMode.equals(currentPortletMode)) {
            state = (FacesPortletState)sessionMap.get(FACES_PORTLET_STATE_PREFIX + currentPortletMode);
            if (state == null) {
                String viewId = this.getCurrentViewId(facesContext);
                this.restoreView(facesContext, viewId);
                return;
            }
            String viewId = state.getViewId();
            requestMap.put(VIEW_ID, viewId);
            this.restoreView(facesContext, viewId);
            Iterator clientIds = state.getClientIds();
            while (clientIds.hasNext()) {
                String clientId = (String)clientIds.next();
                Iterator msgs = state.getMessages(clientId);
                while (msgs.hasNext()) {
                    facesContext.addMessage(clientId, (FacesMessage)msgs.next());
                }
            }
            this.copyMap(state.getRequestMap(), facesContext.getExternalContext().getRequestMap(), new ArrayList());
            Object s = state.getState();
            if (s != null) {
                facesContext.getViewRoot().processRestoreState(facesContext, s);
            }
        } else {
            this.restoreDefaultFacesState(facesContext);
        }
    }

    protected void restoreDefaultFacesState(FacesContext facesContext) {
        String viewId = this.getCurrentViewId(facesContext);
        Iterator i = facesContext.getExternalContext().getSessionMap().entrySet().iterator();
        while (i.hasNext()) {
            String key;
            Map.Entry e = i.next();
            if (!(e.getKey() instanceof String) || !(key = (String)e.getKey()).startsWith(FACES_PORTLET_STATE_PREFIX)) continue;
            facesContext.getExternalContext().getSessionMap().remove(key);
        }
        if (RedirectScope.isRedirecting(facesContext)) {
            RedirectScope.removeContext(facesContext);
        }
        this.restoreView(facesContext, viewId);
    }

    protected String getCurrentViewId(FacesContext facesContext) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String viewId = (String)requestParameterMap.get(VIEW_ID);
        if (viewId != null && !this.checkSessionState(facesContext)) {
            return viewId;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        viewId = (String)requestMap.get(VIEW_ID);
        if (viewId != null && !this.checkSessionState(facesContext)) {
            return viewId;
        }
        viewId = (String)requestMap.get(DEFAULT_PAGE);
        requestMap.put(VIEW_ID, viewId);
        return viewId;
    }

    protected void restoreView(FacesContext facesContext, String viewId) {
        facesContext.getApplication().getViewHandler().restoreView(facesContext, viewId);
        if (facesContext.getViewRoot() == null) {
            facesContext.setViewRoot(facesContext.getApplication().getViewHandler().createView(facesContext, viewId));
        } else {
            facesContext.getViewRoot().setViewId(viewId);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"called processAction..");
        }
        if (this.checkSessionState((PortletRequest)request)) {
            return;
        }
        String viewId = request.getParameter(VIEW_ID);
        if (viewId != null) {
            request.setAttribute(VIEW_ID, (Object)viewId);
            this.executeFaces(request, response);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"skip processAction because viewId is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeFaces(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.storePortletConfig((PortletRequest)request);
        this.setCurrentPortletMode((PortletRequest)request);
        this.createExcludedAttributeList((PortletRequest)request);
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getPortletContext(), request, response, this.lifecycle);
        try {
            this.lifecycle.execute(facesContext);
            if (!facesContext.getResponseComplete()) {
                request.setAttribute(VIEW_ID, (Object)facesContext.getViewRoot().getViewId());
                this.saveFacesState(facesContext);
                if (request.getParameter(RENDER_PARAMETER) != null) {
                    this.setRenderParameters(request, response);
                }
            } else if (RedirectScope.isRedirecting(facesContext)) {
                this.saveFacesState(facesContext);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        finally {
            facesContext.release();
        }
    }

    protected void saveFacesState(FacesContext facesContext) {
        Map sessionMap = facesContext.getExternalContext().getSessionMap();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String currentPortletMode = (String)requestMap.get(CURRENT_PORTLET_MODE);
        sessionMap.put(PREVIOUS_PORTLET_MODE, currentPortletMode);
        FacesPortletState state = new FacesPortletState();
        state.setViewId(facesContext.getViewRoot().getViewId());
        Iterator i = requestMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
        }
        Iterator clientIds = facesContext.getClientIdsWithMessages();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator msgs = facesContext.getMessages(clientId);
            while (msgs.hasNext()) {
                state.addMessage(clientId, (FacesMessage)msgs.next());
            }
        }
        String redirectPath = RedirectScope.getRedirectingPath(facesContext);
        if (redirectPath == null) {
            List excludedNameList = (List)requestMap.get(EXCLUDED_ATTRIBUTE_LIST);
            HashMap map = new HashMap();
            this.copyMap(requestMap, map, excludedNameList);
            state.setRequestMap(map);
            state.setState(facesContext.getViewRoot().processSaveState(facesContext));
        } else {
            state.setViewId(redirectPath);
            HashMap map = new HashMap();
            state.setRequestMap(map);
            state.setState(null);
        }
        sessionMap.put(FACES_PORTLET_STATE_PREFIX + currentPortletMode, state);
    }

    protected void handleException(Throwable e) throws PortletException, IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof PortletException) {
            throw (PortletException)e;
        }
        if (e.getMessage() != null) {
            throw new PortletException(e.getMessage(), e);
        }
        throw new PortletException(e);
    }

    protected boolean checkSessionState(PortletRequest request) {
        return request.getPortletSession(false) == null || request.getPortletSession().getAttribute(REDEPLOYED_PORTLET) == null;
    }

    protected boolean checkSessionState(FacesContext context) {
        return context.getExternalContext().getSession(false) == null || context.getExternalContext().getSessionMap().get(REDEPLOYED_PORTLET) == null;
    }

    protected void createExcludedAttributeList(PortletRequest request) {
        ArrayList excludedNameList = new ArrayList();
        Enumeration enu = request.getAttributeNames();
        while (enu.hasMoreElements()) {
            excludedNameList.add(enu.nextElement());
        }
        excludedNameList.add(EXCLUDED_ATTRIBUTE_LIST);
        excludedNameList.add("facesContext");
        request.setAttribute(EXCLUDED_ATTRIBUTE_LIST, excludedNameList);
    }

    private void copyMap(Map fromMap, Map toMap, List excludedNameList) {
        Iterator i = fromMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            if (toMap.containsKey((String)e.getKey()) || excludedNameList.contains((String)e.getKey())) continue;
            toMap.put(e.getKey(), e.getValue());
        }
    }

    protected void setRenderParameters(ActionRequest request, ActionResponse response) {
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            response.setRenderParameter(key, request.getParameter(key));
        }
    }

    protected class FacesPortletState
    implements Serializable {
        private static final long serialVersionUID = -2877915312956741979L;
        private Map messages = new HashMap();
        private Map requestMap = null;
        private String viewId = null;
        private Object state = null;

        protected FacesPortletState() {
        }

        public void addMessage(String clientId, FacesMessage message) {
            ArrayList<FacesMessage> list = (ArrayList<FacesMessage>)this.messages.get(clientId);
            if (list == null) {
                list = new ArrayList<FacesMessage>();
                this.messages.put(clientId, list);
            }
            list.add(message);
        }

        public Iterator getMessages(String clientId) {
            List list = (List)this.messages.get(clientId);
            if (list != null) {
                return list.iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }

        public StringBuffer getMessagesBuffer(String clientId) {
            List list = (List)this.messages.get(clientId);
            StringBuffer buffer = new StringBuffer();
            if (list != null) {
                Iterator messages = list.iterator();
                while (messages.hasNext()) {
                    FacesMessage message = (FacesMessage)messages.next();
                    buffer.append(" ");
                    buffer.append(message.getDetail());
                }
            }
            return buffer;
        }

        public Iterator getClientIds() {
            return this.messages.keySet().iterator();
        }

        public Map getRequestMap() {
            return this.requestMap;
        }

        public void setRequestMap(Map requestMap) {
            this.requestMap = requestMap;
        }

        public String getViewId() {
            return this.viewId;
        }

        public void setViewId(String viewId) {
            this.viewId = viewId;
        }

        public Object getState() {
            return this.state;
        }

        public void setState(Object state) {
            this.state = state;
        }
    }
}

