/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlSelectBooleanCheckboxRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.SelectBoolean";
    public static final String RENDERER_TYPE = "javax.faces.Checkbox";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlSelectBooleanCheckboxRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("selected");
        this.ignoreComponent.addAttributeName("name");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlSelectBooleanCheckboxEnd(context, (HtmlSelectBooleanCheckbox)component);
    }

    protected void encodeHtmlSelectBooleanCheckboxEnd(FacesContext context, HtmlSelectBooleanCheckbox htmlSelectBooleanCheckbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlSelectBooleanCheckbox);
        RendererUtil.renderAttribute(writer, "type", (Object)"checkbox");
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlSelectBooleanCheckbox, this.getIdForRender(context, htmlSelectBooleanCheckbox));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlSelectBooleanCheckbox.getClientId(context));
        RendererUtil.renderAttribute(writer, "value", Boolean.TRUE);
        String value = ValueHolderUtil.getValueForRender(context, htmlSelectBooleanCheckbox);
        if (this.isChecked(value)) {
            this.renderCheckedAttribute(writer);
        }
        this.renderRemainAttributes(htmlSelectBooleanCheckbox, writer, this.ignoreComponent);
        writer.endElement("input");
    }

    private boolean isChecked(String value) {
        return "true".equalsIgnoreCase(value);
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlSelectBooleanCheckbox(context, (HtmlSelectBooleanCheckbox)component);
    }

    protected void decodeHtmlSelectBooleanCheckbox(FacesContext context, HtmlSelectBooleanCheckbox htmlSelectBooleanCheckbox) {
        if (this.isChecked(context, htmlSelectBooleanCheckbox)) {
            htmlSelectBooleanCheckbox.setSubmittedValue(Boolean.TRUE.toString());
        } else {
            htmlSelectBooleanCheckbox.setSubmittedValue(Boolean.FALSE.toString());
        }
    }

    private boolean isChecked(FacesContext context, UIComponent component) {
        String clientId;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(context))) {
            String value = (String)paramMap.get(clientId);
            return "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || this.isChecked(value);
        }
        return false;
    }

    public void addIgnoreAttributeName(String name) {
        this.ignoreComponent.addAttributeName(name);
    }
}

