/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.portlet.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.portlet.ActionRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;

public class RequestDumpUtil {
    public static void dumpRequestHeaders(StringBuffer sb, PortletRequest request, String lf, String indent) {
    }

    public static void dumpContextAttributes(StringBuffer sb, PortletContext context, String lf, String indent) {
        if (context == null) {
            return;
        }
        Iterator it = RequestDumpUtil.toSortedSet(context.getAttributeNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object attr = context.getAttribute(name);
            sb.append(indent);
            sb.append("[context]").append(name).append("=").append(attr);
            sb.append(lf);
        }
    }

    public static void dumpCookies(StringBuffer sb, PortletRequest request, String lf, String indent) {
    }

    public static void dumpRequestAttributes(StringBuffer sb, PortletRequest request, String lf, String indent) {
        Iterator it = RequestDumpUtil.toSortedSet(request.getAttributeNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object attr = request.getAttribute(name);
            sb.append(indent);
            sb.append("[request]").append(name).append("=").append(attr);
            sb.append(lf);
        }
    }

    public static void dumpSessionAttributes(StringBuffer sb, PortletRequest request, String lf, String indent) {
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            return;
        }
        Iterator it = RequestDumpUtil.toSortedSet(session.getAttributeNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object attr = session.getAttribute(name);
            sb.append(indent);
            sb.append("[session]").append(name).append("=").append(attr);
            sb.append(lf);
        }
    }

    private static SortedSet toSortedSet(Enumeration enu) {
        TreeSet set = new TreeSet();
        set.addAll(Collections.list(enu));
        return set;
    }

    public static void dumpRequestParameters(StringBuffer sb, PortletRequest request, String lf, String indent) {
        Iterator it = RequestDumpUtil.toSortedSet(request.getParameterNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            sb.append(indent);
            sb.append("[param]").append(name).append("=");
            String[] values = request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(values[i]);
            }
            sb.append(lf);
        }
    }

    public static void dumpRequestProperties(StringBuffer sb, PortletRequest request, String lf, String indent) {
        sb.append(indent);
        sb.append("Request class=" + request.getClass().getName()).append(", instance=").append(request.toString().trim());
        sb.append(lf);
        sb.append(indent);
        sb.append("RequestedSessionId=").append(request.getRequestedSessionId());
        sb.append(lf);
        sb.append(indent);
        sb.append(lf);
        sb.append(indent);
        if (request instanceof ActionRequest) {
            ActionRequest arequest = (ActionRequest)request;
            sb.append("CharacterEncoding=" + arequest.getCharacterEncoding());
            sb.append(", ContentLength=").append(arequest.getContentLength());
            sb.append(", ContentType=").append(arequest.getContentType());
        }
        sb.append(", Locale=").append(request.getLocale());
        sb.append(", Locales=");
        Enumeration locales = request.getLocales();
        boolean first = true;
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(locale.toString());
        }
        sb.append(", Scheme=").append(request.getScheme());
        sb.append(", isSecure=").append(request.isSecure());
        sb.append(lf).append(indent);
        sb.append(", SERVER_NAME=").append(request.getServerName());
        sb.append(", SERVER_PORT=").append(request.getServerPort());
        sb.append(lf).append(indent);
        sb.append("ContextPath=").append(request.getContextPath());
        sb.append(", RemoteUser=").append(request.getRemoteUser());
        sb.append(lf);
    }

    public static void dumpContextProperties(StringBuffer sb, PortletContext context, String lf, String indent) {
        sb.append(indent);
        sb.append("ContextRealPath=").append(context.getRealPath("/"));
        sb.append(lf).append(indent);
        sb.append("SERVER_SOFTWARE=").append(context.getServerInfo());
        sb.append(", PortletContextName=").append(context.getPortletContextName());
        sb.append(", MajorVersion=").append(context.getMajorVersion());
        sb.append(", MinorVersion=").append(context.getMinorVersion());
    }

    public static void dumpSessionProperties(StringBuffer sb, PortletRequest request, String lf, String indent) {
        PortletSession session = request.getPortletSession(false);
        if (session == null) {
            return;
        }
        sb.append(indent);
        sb.append("Session SessionId=").append(session.getId());
        sb.append(lf).append(indent);
        sb.append("Session :: CreationTime=").append(session.getCreationTime());
        sb.append(", LastAccessedTime=").append(session.getLastAccessedTime());
        sb.append(", MaxInactiveInterval=").append(session.getMaxInactiveInterval());
        sb.append(lf);
    }

    public static void dumpResponseProperties(StringBuffer sb, PortletResponse response, String lf, String indent) {
        sb.append(indent);
        sb.append("Response class=" + response.getClass().getName()).append(", instance=").append(response.toString().trim());
        sb.append(lf);
    }
}

