package jp.sf.pal.helloworld;

import java.io.IOException;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * HelloWorldPortlet is a portlet to say "Hello!"
 * 
 * @author <a href="mailto:shinsuke@yahoo.co.jp">Shinsuke Sugaya</a>
 */
public class HelloWorldPortlet extends GenericPortlet {

    public static final String YOUR_NAME_KEY = "yourName";

    public void init() throws PortletException {
    }

    public void destroy() {
    }

    protected void doView(RenderRequest request, RenderResponse response)
            throws PortletException, IOException {
        response.setContentType("text/html");

        String yourName = request.getParameter(YOUR_NAME_KEY);
        if (yourName == null) {
            yourName = "";
        }
        request.setAttribute(YOUR_NAME_KEY, yourName);

        PortletContext context = getPortletContext();
        PortletRequestDispatcher rd = context
                .getRequestDispatcher("/helloworld.jsp");
        rd.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response)
            throws PortletException, IOException {
        String yourName = request.getParameter(YOUR_NAME_KEY);
        if (yourName != null) {
            response.setRenderParameter(YOUR_NAME_KEY, yourName);
        }
        return;
    }

}
