package jp.sf.pal.ggadget.util;

import java.io.IOException;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import javax.servlet.http.HttpServletRequest;

import jp.sf.pal.ggadget.GGadgetConstants;
import jp.sf.pal.ggadget.entity.GGadget;

import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.seasar.struts.portlet.util.PortletUtil;
import org.seasar.struts.util.ActionMessagesUtil;

public class GGadgetUtil {
    public static void addMessage(HttpServletRequest request, String key) {
        ActionMessages msgs = new ActionMessages();
        msgs.add(ActionMessages.GLOBAL_MESSAGE, new ActionMessage(key));
        ActionMessagesUtil.saveMessages(request, msgs);
    }

    public static String getPreferenceValue(HttpServletRequest request,
            String key, String defaultValue) {
        PortletRequest portletRequest = (PortletRequest) request
                .getAttribute(PortletUtil.PORTLET_REQUEST);
        if (portletRequest != null) {
            PortletPreferences preferences = portletRequest.getPreferences();
            return preferences.getValue(key, defaultValue);
        }
        return null;
    }

    public static String store(HttpServletRequest request, GGadget gGadget)
            throws ValidatorException, IOException, ReadOnlyException {
        PortletRequest portletRequest = (PortletRequest) request
                .getAttribute(PortletUtil.PORTLET_REQUEST);
        if (portletRequest != null) {
            PortletPreferences preferences = portletRequest.getPreferences();
            preferences.setValue(GGadgetConstants.NAME, gGadget.getName());
            preferences.setValue(GGadgetConstants.DESCRIPTION, gGadget
                    .getDescription());
            preferences.setValue(GGadgetConstants.URL, gGadget.getUrl());
            preferences.setValue(GGadgetConstants.THUMBNAIL, gGadget
                    .getThumbnail());
            preferences.store();
        }
        return null;
    }
}
