/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.action;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.RequestUtils;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.portlet.servlet.SAStrutsActionRequest;
import org.seasar.struts.portlet.servlet.SAStrutsRequest;
import org.seasar.struts.portlet.util.PortletUtil;
import org.seasar.struts.util.S2ActionMappingUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;

public class S2RequestProcessor
extends org.seasar.struts.action.S2RequestProcessor {
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (PortletUtil.isPortletRequest((ServletRequest)request)) {
            String forwardPath = (String)request.getAttribute("org.seasar.struts.portlet.forward_path");
            if (forwardPath != null) {
                this.doForward(forwardPath, request, response);
            } else {
                super.process(request, response);
            }
        } else {
            super.process(request, response);
        }
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processForwardConfig(" + forward + ")"));
        }
        String forwardPath = forward.getPath();
        String uri = null;
        uri = forwardPath.startsWith("/") ? RequestUtils.forwardURL((HttpServletRequest)request, (ForwardConfig)forward, null) : forwardPath;
        if (forward.getRedirect()) {
            if (PortletUtil.isPortletRequest((ServletRequest)request)) {
                if (PortletUtil.isActionRequest((ServletRequest)request)) {
                    if (uri.indexOf(":") == -1) {
                        if (request instanceof SAStrutsActionRequest) {
                            String contextPath = PortletUtil.getActionRequest((ServletRequest)request).getContextPath();
                            ((SAStrutsActionRequest)request).getProcessActionConfig().init(contextPath + uri, contextPath, request.getCharacterEncoding());
                        }
                    } else {
                        PortletUtil.getActionRequest((ServletRequest)request).setAttribute("org.seasar.struts.portlet.redirect", (Object)Boolean.TRUE);
                        response.sendRedirect(response.encodeRedirectURL(uri));
                    }
                }
            } else {
                if (uri.startsWith("/")) {
                    uri = request.getContextPath() + uri;
                }
                response.sendRedirect(response.encodeRedirectURL(uri));
            }
        } else if (PortletUtil.isPortletRequest((ServletRequest)request)) {
            if (PortletUtil.isActionRequest((ServletRequest)request)) {
                PortletUtil.getActionRequest((ServletRequest)request).setAttribute("org.seasar.struts.portlet.forward_path", (Object)uri);
                if (this.isExporablePath(uri)) {
                    this.exportPropertiesToRequest(request, S2ActionMappingUtil.getActionMapping(), S2ExecuteConfigUtil.getExecuteConfig());
                }
            } else {
                this.doForward(uri, request, response);
            }
        } else {
            this.doForward(uri, request, response);
        }
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request instanceof SAStrutsRequest) {
            SAStrutsRequest sRequest = (SAStrutsRequest)request;
            sRequest.setRequestURI(request.getContextPath() + uri);
            int index = uri.indexOf("?");
            String queryString = null;
            if (index == -1) {
                sRequest.setServletPath(uri);
                queryString = null;
            } else {
                sRequest.setServletPath(uri.substring(0, index));
                queryString = uri.substring(index + 1);
            }
            sRequest.setPathInfo(null);
            if (!StringUtil.isEmpty(queryString)) {
                sRequest.setQueryString(queryString);
            } else {
                sRequest.setQueryString(null);
            }
        }
        super.doForward(uri, request, response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request instanceof SAStrutsRequest) {
            SAStrutsRequest sRequest = (SAStrutsRequest)request;
            sRequest.setRequestURI(request.getContextPath() + uri);
            int index = uri.indexOf("?");
            String queryString = null;
            if (index == -1) {
                sRequest.setServletPath(uri);
                queryString = null;
            } else {
                sRequest.setServletPath(uri.substring(0, index));
                queryString = uri.substring(index + 1);
            }
            sRequest.setPathInfo(null);
            if (!StringUtil.isEmpty(queryString)) {
                sRequest.setQueryString(queryString);
            } else {
                sRequest.setQueryString(null);
            }
        }
        super.doInclude(uri, request, response);
    }

    protected void exportPropertiesToRequest(HttpServletRequest request, S2ActionMapping actionMapping, S2ExecuteConfig executeConfig) {
        if (request.getAttribute("org.seasar.struts.portlet.forward_path") == null || !PortletUtil.isRenderRequest((ServletRequest)request)) {
            super.exportPropertiesToRequest(request, actionMapping, executeConfig);
        }
    }
}

