/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.portlet.filter;

import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.filter.RoutingFilter;
import org.seasar.struts.portlet.servlet.SAStrutsRequest;
import org.seasar.struts.portlet.util.PortletUtil;

public class PortletRoutingFilter
extends RoutingFilter {
    protected static final String DONE = "org.seasar.struts.portlet.filter.PortletRoutingFilter.done";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (PortletUtil.isPortletRequest(request)) {
            PortletRequest portletRequest = PortletUtil.getPortletRequest(request);
            if (PortletUtil.isSAStrutsStarted(request) && portletRequest.getAttribute(DONE) == null) {
                portletRequest.setAttribute(DONE, (Object)Boolean.TRUE);
                super.doFilter(request, response, chain);
                if (PortletUtil.isActionRequest(request)) {
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void forward(HttpServletRequest request, HttpServletResponse response, String actionPath, String paramPath, S2ExecuteConfig executeConfig) throws IOException, ServletException {
        String servletPath = actionPath + ".do";
        String forwardPath = String.valueOf(servletPath);
        String queryString = null;
        if (executeConfig != null) {
            queryString = executeConfig.getQueryString(paramPath);
            forwardPath = forwardPath + queryString;
        }
        if (request instanceof SAStrutsRequest) {
            SAStrutsRequest sRequest = (SAStrutsRequest)request;
            sRequest.setContextPath(request.getContextPath());
            sRequest.setRequestURI(request.getContextPath() + forwardPath);
            sRequest.setServletPath(servletPath);
            sRequest.setPathInfo(null);
            if (!StringUtil.isEmpty((String)queryString)) {
                sRequest.setQueryString(queryString.substring(1));
            } else {
                sRequest.setQueryString(null);
            }
        }
        if (!PortletUtil.isActionRequest((ServletRequest)request)) {
            request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

