/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.struts.util.RequestUtil;

public final class ResponseUtil {
    private ResponseUtil() {
    }

    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)SingletonS2Container.getComponent(HttpServletResponse.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String fileName, byte[] data) {
        HttpServletResponse response = ResponseUtil.getResponse();
        try {
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            ServletOutputStream out = response.getOutputStream();
            try {
                out.write(data);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(String text) {
        ResponseUtil.write(text, null, null);
    }

    public static void write(String text, String contentType) {
        ResponseUtil.write(text, contentType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String text, String contentType, String encoding) {
        if (contentType == null) {
            contentType = "text/plain";
        }
        if (encoding == null && (encoding = RequestUtil.getRequest().getCharacterEncoding()) == null) {
            encoding = "UTF-8";
        }
        HttpServletResponse response = ResponseUtil.getResponse();
        response.setContentType(contentType + "; charset=" + encoding);
        try {
            PrintWriter out = null;
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding));
                out.print(text);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

