package jp.sf.pal.nvwidget.pager;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import jp.sf.pal.nvwidget.NvWidgetConstants;

public class NvWidgetPager implements Serializable {

    private static final long serialVersionUID = 237701365907034437L;

    private int page = 1;

    private int limit = 20;

    private String category;

    private String query;

    private String region = "us";

    public void reset() {
        page = 1;
        limit = 20;
        category = null;
        query = null;
        region = "us";
    }

    public String buildUrl() {
        StringBuilder url = new StringBuilder(NvWidgetConstants.BASE_URL);

        url.append("&page=").append(page);
        url.append("&limit=").append(limit);
        if (category != null) {
            url.append("&category=").append(category);
        }
        if (query != null && !"".equals(query)) {
            try {
                url.append("&query=").append(URLEncoder.encode(query, "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                // TODO
            }
        }
        if (region != null) {
            url.append("&region=").append(region);
        }
        return url.toString();
    }

    public int getPage() {
        return page;
    }

    public void setPage(int start) {
        this.page = start;
    }

    public int getLimit() {
        return limit;
    }

    public void setLimit(int num) {
        this.limit = num;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String language) {
        this.region = language;
    }
}
