package jp.sf.pal.nvwidget.util;

import java.util.ArrayList;
import java.util.List;

import jp.sf.pal.nvwidget.entity.NvWidget;
import jp.sf.pal.nvwidget.pager.NvWidgetPager;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NvWidgetHandler extends DefaultHandler {

    private NvWidgetList<NvWidget> nvWidgetList;

    private NvWidget nvWidget;

    private List<String> stack;

    private NvWidgetPager nvWidgetPager;

    public NvWidgetHandler(NvWidgetPager nvWidgetPager) {
        super();
        this.nvWidgetPager = nvWidgetPager;
    }

    @Override
    public void startDocument() throws SAXException {
        stack = new ArrayList<String>();
    }

    @Override
    public void endDocument() throws SAXException {
        stack = null;
    }

    @Override
    public void startElement(String uri, String localName, String name,
            Attributes attributes) throws SAXException {
        stack.add(name);

        if ("items".equals(name)) {
            nvWidgetList = new NvWidgetList<NvWidget>();

            if (nvWidgetPager.getPage() > 1) {
                nvWidgetList.setExistPrevPage(true);
            } else {
                nvWidgetList.setExistPrevPage(false);
            }

            for (int i = 0; i < attributes.getLength(); i++) {
                String attrName = attributes.getQName(i);
                String attrValue = attributes.getValue(i);
                if ("total".equals(attrName)) {
                    try {
                        nvWidgetList.setAllRecordCount(Integer
                                .parseInt(attrValue));
                    } catch (NumberFormatException e) {
                        nvWidgetList.setAllRecordCount(0);
                    }
                } else if ("page".equals(attrName)) {
                    try {
                        nvWidgetList.setCurrentPageNumber(Integer
                                .parseInt(attrValue));
                    } catch (NumberFormatException e) {
                        nvWidgetList.setCurrentPageNumber(nvWidgetPager
                                .getPage());
                    }
                } else if ("totalPages".equals(attrName)) {
                    try {
                        nvWidgetList.setAllPageCount(Integer
                                .parseInt(attrValue));
                    } catch (NumberFormatException e) {
                        nvWidgetList.setAllPageCount(1);
                    }

                    if (nvWidgetPager.getPage() < nvWidgetList
                            .getAllPageCount()) {
                        nvWidgetList.setExistNextPage(true);
                    } else {
                        nvWidgetList.setExistNextPage(false);
                    }
                }
            }

        } else if ("item".equals(name)) {
            nvWidget = new NvWidget();
        }
    }

    @Override
    public void endElement(String uri, String localName, String name)
            throws SAXException {
        if ("item".equals(name)) {
            nvWidgetList.add(nvWidget);
            nvWidget = null;
        }

        stack.remove(stack.size() - 1);
    }

    @Override
    public void characters(char[] ch, int start, int length)
            throws SAXException {
        if (stack != null) {
            String tagName = stack.get(stack.size() - 1);
            if (nvWidget != null) {
                if ("id".equals(tagName)) {
                    nvWidget.setId(new String(ch, start, length));
                } else if ("title".equals(tagName)) {
                    nvWidget.setName(nvWidget.getName()
                            + new String(ch, start, length));
                } else if ("link".equals(tagName)) {
                    nvWidget.setUrl(new String(ch, start, length));
                } else if ("description".equals(tagName)) {
                    nvWidget.setDescription(nvWidget.getDescription()
                            + new String(ch, start, length));
                } else if ("thumbnail".equals(tagName)) {
                    nvWidget.setThumbnail(new String(ch, start, length));
                }
            }
        }
    }

    public NvWidgetList<NvWidget> getNvWidgetList() {
        return nvWidgetList;
    }
}
